<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2010 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts VistaCart                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+

App::import('Sanitize');

class NewsletterusersController extends AppController

{

    var $name = "Newsletteruser";

    var $helpers = array('Html', 'Form','Pagination');   

	var $components = array ('Pagination','Catmenu','History','Email','Streamsend'); // Added

	var $uses = array('Newsletteruser');

	var $paginate = array('limit' => 25,'order' => array('Newsletteruser.uname' => 'asc'));

    function index()

    {

       $this->__validateLoginStatus(); 

	   $admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$criteria=NULL;

		$cmbSearchType	=	"";

		$txtSearch		=	"";

		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){

			$cmbSearchType	=	$_GET["cmbSearchType"];

			$txtSearch		=	$_GET["txtSearch"];			

			$data = $this->paginate('Newsletteruser', array('Newsletteruser.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

		}

		else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && 

		 $this->passedArgs["txtSearch"] <> '')

		{

		    $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

			$txtSearch		=	$this->passedArgs["txtSearch"];	

			$data = $this->paginate('Newsletteruser', array('Newsletteruser.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

		}

		else{

			$data = $this->paginate('Newsletteruser');

		}

		$this->set('cmbSearchType', $cmbSearchType);

		$this->set('txtSearch', $txtSearch);

		$this->set('usr', $data);

		$this->passedArgs['limit']=$this->paginate["limit"];

		$this->set('passedarg',$this->passedArgs);

		$this->layout = 'adm'; 

    } 

    function beforeFilter()

    {

        if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        } 

		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);

		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

		$this->set('sitefolder', $sitefolder);

		$httpHost	=	$_SERVER['HTTP_HOST'];

		$this->set('sitebase','http://'.$httpHost);

    }

	function beforeRender(){				

		

	}

	

	function add() {

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}
                
                //echo '<pre>'; print_r($this->data); echo '</pre>'; exit();

		if (!empty($this->data)) {		

		        $dups = $this->Newsletteruser->findByEmail($this->data["Newsletteruser"]["email"]);
                        $dupsUsername = $this->Newsletteruser->findByUname($this->data["Newsletteruser"]["uname"]);

				if (!empty($dups['Newsletteruser']['email'])){

					$this->Session->setFlash(__('Email Id Already Exists!', true));

					$this->redirect(array('controller'=>'newsletterusers','action'=>'index'));

					exit;

				}
                                if (!empty($dupsUsername['Newsletteruser']['uname'])){

					$this->Session->setFlash(__('User Name Already Exists!', true));

					$this->redirect(array('controller'=>'newsletterusers','action'=>'index'));

					exit;

				}


                                $this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {                                
                                //*****************Add user to Streamsend ************
                                if(isset($cnfg['streamsendLoginID']) && isset($cnfg['streamsendKey']) && isset($cnfg['streamsendListID']) && $cnfg['streamsendEnable'] == 'Y'  ) {
                                    $this->Streamsend->loginID    = $cnfg['streamsendLoginID'];
                                    $this->Streamsend->key        = $cnfg['streamsendKey'];
                                    $this->Streamsend->listID     = $cnfg['streamsendListID'];

                                    //add member
                                    $person = array("email" => $this->data["Newsletteruser"]["email"],
                                            "fname" => $this->data["Newsletteruser"]["uname"],
                                            "lname" => $this->data["Newsletteruser"]["uname"]);

                                    $this->Streamsend->addstreamsendpeople($this->Streamsend->getXMLAddEmail($person));

                                    $mid = $this->Streamsend->getpeople($person['email']);

                                    
                                        $this->Streamsend->addmembership($mid);
                                    
                                }
                                //***********************************
                                
				$this->Session->setFlash(__('Subscriber has been saved successfully!', true));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}

		$this->layout = 'adm';

	}

	

		function edit($id=0) {

		if($id == 0){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$this->Newsletteruser->id = $id; 

		if (!empty($this->data)) {			  

			   $dups = $this->Newsletteruser->find('count', array('conditions' => array('Newsletteruser.id <> '.$id,'Newsletteruser.email' => $this->data["Newsletteruser"]["email"])));						   	

				if ($dups > 0){

					$this->Session->setFlash(__('Email Id Already Exists!', true));

					$this->redirect(array('controller'=>'newsletterusers','action'=>'index'));

					exit;

				}

				

			$this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {

					$this->Session->setFlash(__('Subscriber details has been updated successfully!', true));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}else{

			$this->data = $this->Newsletteruser->read();			

		}

		$this->layout = 'adm';

	} 

	

	function setStatus($uid='',$status='')

	{

	    $this->Newsletteruser->id = $uid;

		$this->Newsletteruser->saveField('status',$status);

	    $this->Session->setFlash(__('Subscriber status has been updated successfully!', true));

	    $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

	}

	

	function delete($delid='')

	{

	  if($delid==''){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}

	  if($this->Newsletteruser->del($delid)){

			$this->Session->setFlash(__('Subscriber has been deleted Successfully.', true));

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit;

		   }

	}	   

	

	

    function __validateLoginStatus($typ='A')

    {

           if($typ == 'A'){

				if($this->Session->check('Admin') == false)

				{

					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 

					 $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

				}

			}else{

				if($this->Session->check('Userlog') == false)

				{

					$this->redirect(array('controller' => 'users', 'action' => 'login')); 

					 $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));

				}

			}

    } 	

}

?>