<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | file to define the global variables needed in the application        |
// | File name : globals.php                                                 |
// | PHP version >= 5.2                                                   |
// | Created On 19 Dec 2011                                               |
// +----------------------------------------------------------------------+
// | Author: JINSON MATHEW <jinson.m@armiasystems.com>                    |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2011                                      |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+

// If the server is cgi
ini_set('cgi.fix_pathinfo', 1);


//register global post actions
PageContext::$response->operation_mode = Apputils::fetchSettings("operation_mode");

// Fetch settings
PageContext::$response->settings = Apputils::loadSettings();

if(PageContext::$response->operation_mode == 3)
{
    $destinations = Search::fetchDestinations(4);
    if(count($destinations)>0)
    {
        PageContext::$response->footerDestinations = $destinations;
    }
}
PageContext::$response->firstDestinationId = 0;

if(PageContext::$response->operation_mode == 2 || PageContext::$response->operation_mode == 3 )
{  

    if(PageContext::$response->operation_mode == 2)
    {

        $destinations = Search::fetchDestinations(4);

        if(count($destinations)>0)
        {
            PageContext::$response->footerDestinations = $destinations;
        }

        PageContext::$response->firstDestinationId = Search::fetchDefaultDestination();
        $locations                                 = Search::fetchLocations(PageContext::$response->firstDestinationId,FALSE,4);

    }
    else
        $locations = Search::fetchLocations(NULL,FALSE,4,0);

    if(count($locations)>0)
    {
        PageContext::$response->footerLocations = $locations;
    }
}
else if(PageContext::$response->operation_mode == 1)
{
  PageContext::$response->firstDestinationId = Search::fetchDefaultDestination();
}

$deals = Search::fetchDestinations(4);
if(count($deals)>0){
    PageContext::$response->footerDeals = $deals;
}

PageContext::addJsVar("ENABLE_GOOGLE_MAP", PageContext::$response->settings['GoogleMap']);


PageContext::$response->siteLogoPath = Apputils::loadSiteLogo();



PageContext::$response->siteLogoFooterPath = Apputils::loadSiteLogoFooter();
PageContext::registerPostAction("footer", "footerpanel","index","default");
PageContext::registerPostAction("header", "headerpanel","index","default");

$imageConfig = array (
                       "location"       => array('directory'=>'','prefix' => '','height' => 915,'width' => 405),
                       "locationThumb"  => array('directory'=>'locationThumb','prefix' => '','height' => 93,'width' => 62),
                       "locationTinyThumb"  => array('directory'=>'locationThumb','prefix' => '','height' => 20,'width' => 20),
                       "destination"       => array('directory'=>'destination','prefix' => '','height' => 915,'width' => 405),
                       "destinationThumb"  => array('directory'=>'destinationThumb','prefix' => '','height' => 93,'width' => 62),
                       "offerThumb"  => array('directory'=>'','prefix' => 'offerThumb','height' => 112,'width' => 120)

                     );

define('BASIC_LIST_COUNT',5);
define('PRICE_SLIDER_MIN_RANGE',0);
define('PRICE_SLIDER_MAX_RANGE',100000);

define('MAXIMUM_SEARCHABLE_ADULTS_COUNT',10);
PageContext::addJsVar("MAXIMUM_SEARCHABLE_ADULTS_COUNT", MAXIMUM_SEARCHABLE_ADULTS_COUNT);

define('MAXIMUM_SEARCHABLE_CHILDREN_COUNT',10);
PageContext::addJsVar("MAXIMUM_SEARCHABLE_CHILDREN_COUNT", MAXIMUM_SEARCHABLE_CHILDREN_COUNT);

define('MAXIMUM_SEARCHABLE_ROOM_COUNT',10);
PageContext::addJsVar("MAXIMUM_SEARCHABLE_ROOM_COUNT", MAXIMUM_SEARCHABLE_ROOM_COUNT);

define('SITE_CURRENCY',Utils::getSettingsData('currency'));

define('RECAPTCHA_PUBLICKEY','6LfryNQSAAAAAHh7zgGqZUYgp7oJDDmq49tBj9Rz');
define('RECAPTCHA_PRIVATEKEY','6LfryNQSAAAAAEQGT_gjWxwxVAlfRu37pDR3sR1f');


$tempSiteStyle = Apputils::fetchSettings('sitestyle');
if(trim($tempSiteStyle) == '')
define('CURRENT_THEME','default');
else
define('CURRENT_THEME',$tempSiteStyle);

PageContext::$response->startDayOfMonth = date('m/01/Y',strtotime(date('m/d/Y')));
PageContext::$response->endDayOfMonth = date('m/t/Y',strtotime(date('m/d/Y')));

  
function echopre($printArray) {
    echo "<pre>";
    print_r($printArray);
    echo "</pre>";
}

function echopre1($printArray) {
    echo "<pre>";
    print_r($printArray);
    echo "</pre>";
    exit();
}

PageContext::addJsVar("mainUrl", BASE_URL);



// Php backward compatibility Fixes



// json_decode function missing
if(!function_exists('json_decode')){ 
    
    require_once 'project/lib/json/JSON.php';
    function json_decode($content, $assoc=false) {
        if ($assoc) {
            $json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
        }
        else {
            $json = new Services_JSON;
        }
        return $json->decode($content);
    }
}


// json_encode function missing
if(!function_exists('json_encode')){
    require_once 'project/lib/json/JSON.php';
    function json_encode($content) {
        $json = new Services_JSON;
        return $json->encode($content);
    }
}

// Function to refine  call_user_func() [php compatibility fix]
 function call_user_func_refined($functionName,$params1=null,$params2=null) {
    if(phpversion() < '5.2'){
        $dataVal          =  explode("::",$functionName);
        if($params1!='' && $params2!='')
            $functionVal      =  call_user_func(array($dataVal[0],$dataVal[1]),$params1,$params2);
        else if($params1!='')
            $functionVal      =  call_user_func(array($dataVal[0],$dataVal[1]),$params1);
        else
            $functionVal      =  call_user_func(array($dataVal[0],$dataVal[1]));
    }else{
        if($params1!='' && $params2!='')
            $functionVal      =  call_user_func($functionName,$params1,$params2);
        else if($params1!='')
            $functionVal      =  call_user_func($functionName,$params1);
        else
            $functionVal      =  call_user_func($functionName);
    }
    return $functionVal;
}


// Php backward compatibility Fixes

 
?>
