<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Apisearch {
  
	
	/*
	 * function to get he list of hotels
	 */
	
	public static function expediaListHotels($searchParams = array())
	{



		$expediaparams 	= self::getExpediaSettings();
		PageContext::includePath('expedia');
		$expedia 		= new Expedia();
		$result 		= $expedia->listhotels($searchParams,$expediaparams);



               

		$result = self::filterExpediaHotelList($result);

                 
		return $result;
	}
	
	/*
	 * function to get a particular hotel information
	 */
	public static function expediaHotelInfo($searchParams = array())
	{
		$expediaparams 	= self::getExpediaSettings();
		PageContext::includePath('expedia');
		$expedia 		= new Expedia();	 
		$result 		= $expedia->getHotelInfo($searchParams,$expediaparams);
	 	//echopre($result);
		$result = self::filterHotelInfo($result);
		
		return $result;
	}
	
	
	public static function getExpediaRoomInfo($searchParams = array())
	{
		$expediaSettings 		= Apisearch::getExpediaSettings();
		$bookingInfo['hotelId']			= $searchParams['hotelId'];
		$bookingInfo['arrivalDate']		= $searchParams['arrivalDate'];
		$bookingInfo['departureDate']	= $searchParams['departureDate'];
		$bookingInfo['room1']			= $searchParams['room1'];
		
		// code to find the rate key
		$getRateKey = 'http://api.ean.com/ean-services/rs/hotel/v3/avail?minorRev='.$expediaSettings['minorRev'].'&cid='.$expediaSettings['cid'].'&apiKey='.$expediaSettings['apiKey'].'&customerUserAgent=&customerIpAddress=&customerSessionId=&locale='.$expediaSettings['locale'].'&currencyCode='.$expediaSettings['currencyCode'].'&hotelId='.$bookingInfo['hotelId'].'&arrivalDate='.$bookingInfo['arrivalDate'].'&departureDate='.$bookingInfo['departureDate'].'&includeDetails=true&includeRoomImages=true&room1='.$bookingInfo['room1'];
		$info 		= file_get_contents($getRateKey); 
		$info 		= json_decode($info);
		
		 
		$params 	= 'ratekey='.$info->HotelRoomAvailabilityResponse->rateKey;
		
		if(sizeof($info->HotelRoomAvailabilityResponse->HotelRoomResponse) > 1)	{
			$params .= '&roomtype='.$info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->roomTypeCode;
		  	$params .= '&ratecode='.$info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->rateCode;
			
		  	$arrHotelInfo = get_object_vars($info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->RateInfo->ChargeableRateInfo);
		  	$params .= '&rate='.$arrHotelInfo['@total'];
		  	
		  	
			$result = 'result=success&'.$params;
		}
		else if(sizeof($info->HotelRoomAvailabilityResponse->HotelRoomResponse) == 1) {
			$params .= '&roomtype='.$info->HotelRoomAvailabilityResponse->HotelRoomResponse->roomTypeCode;
		  	$params .= '&ratecode='.$info->HotelRoomAvailabilityResponse->HotelRoomResponse->rateCode;
		  	$arrHotelInfo = get_object_vars($info->HotelRoomAvailabilityResponse->HotelRoomResponse->RateInfo->ChargeableRateInfo);
		  	$params .= '&rate='.$arrHotelInfo['@total'];
		  	
			$result = 'result=success&'.$params;
		}
		else 
			$result = 'result=error&msg='.$info->HotelRoomAvailabilityResponse->EanWsError->verboseMessage;
		
		return $result;
		
	}
	 
	
	
	
	/*
	 * function to get the expedia settings details
	 */
	public static function getExpediaSettings()
	{
		$dbObj 								= new Db();
		$expediaparams 						= array();
		$expediaparams['customerUserAgent'] = ''; 
		$expediaparams['customerIpAddress'] = ''; 
		$expediaparams['locale'] 			= 'en_US'; 

		//$expediaparams['minorRev'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_version'");	
		$expediaparams['cid'] 				= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_cid'");
                //$expediaparams['cid'] 				= 55505;
		$expediaparams['apiKey'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_apikey'");
		$expediaparams['currencyCode'] 		= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_currency'");
		
		$expediaparams['locale'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_locale'");
		//$expediaparams['currencyCode'] 		= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='expedia_currency'");

		return $expediaparams;
	}
	
	
	
	/*
	 * function to filter the hotel list
	 */
	public function filterExpediaHotelList($hotelList)
	{
		if($hotelList->HotelListResponse->moreResultsAvailable >= 1){
			$expediaPagination['moreResultsAvailable']	=	1;
			$expediaPagination['cacheKey']	=	$hotelList->HotelListResponse->cacheKey;
			$expediaPagination['cacheLocation']	=	$hotelList->HotelListResponse->cacheLocation;
			
			 
		}
		 
		 
		 
		 
		$arrHotel	= array();
		$i = 0;
		foreach($hotelList->HotelListResponse->HotelList->HotelSummary as $hotels)
		{


                      if(trim($hotels->hotelId) != '')
                      {


			$hotelResult 					= new stdClass();
			$hotelResult->nLocation_Id 			= $hotels->hotelId;
			$hotelResult->vLatitude 			= $hotels->latitude;		
			$hotelResult->vLongtitude  			= $hotels->longitude;		
			$hotelResult->vLocation_Name  		= $hotels->name;		
			 $hotelResult->vLocation_Description = strip_tags(html_entity_decode($hotels->shortDescription));	


			
			$hotelResult->Address  				= $hotels->address1;	
			$hotelResult->vCode  				= '';
			$hotelResult->nStartingPrice  		= $hotels->lowRate;
			
			$imgPath = str_replace('t','b', basename($hotels->thumbNailUrl));
			$pathInfo =  pathinfo($hotels->thumbNailUrl);
			$newPath = $pathInfo['dirname'].'/'.$imgPath;
			$hotelResult->image  				= $newPath;
			
			$hotelResult->reviewCount  			= '';	
			$hotelResult->averageRating  		= $hotels->hotelRating;
			$hotelResult->type  				= 'expedia';
			$arrHotel[$i]=$hotelResult;
			$i++;
                        
                        
            }






		} 
		$expediaDet['pages'] = $expediaPagination;
		$expediaDet['data'] = $arrHotel;
		
		 
		return $expediaDet;	
	}
	
	
	
	
	/*
	 * function to filtert the hotel information
	 */
	
	public function filterHotelInfo($hotelInfo)
	{
		//  echopre($hotelInfo);
		$locationDetails = new stdClass();
		$locationDetails->locationDescription 	= strip_tags(html_entity_decode($hotelInfo->HotelInformationResponse->HotelDetails->propertyDescription));			
		$locationDetails->locationName 			= $hotelInfo->HotelInformationResponse->HotelSummary->name;
		$locationDetails->locationAddress 		= $hotelInfo->HotelInformationResponse->HotelSummary->address1.' '.$hotelInfo->HotelInformationResponse->HotelSummary->address2;
		$locationDetails->locationStartingPrice = $hotelInfo->HotelInformationResponse->HotelSummary->lowRate;
		$locationDetails->destinationId 		= $hotelInfo->HotelInformationResponse->HotelSummary->hotelId;
		$locationDetails->city 					= $hotelInfo->HotelInformationResponse->HotelSummary->city;
		$locationDetails->countryCode 			= $hotelInfo->HotelInformationResponse->HotelSummary->countryCode;
		
		$locationDetails->latitude 				= $hotelInfo->HotelInformationResponse->HotelSummary->latitude;
		$locationDetails->longitude 			= $hotelInfo->HotelInformationResponse->HotelSummary->longitude;
		
		// get the amenities
		if(sizeof($hotelInfo->HotelInformationResponse->PropertyAmenities->PropertyAmenity) > 0) {
			$amenityInfo = '';
			foreach($hotelInfo->HotelInformationResponse->PropertyAmenities->PropertyAmenity as $amenity) {
				$amenityInfo .= $amenity->amenity.' ,';
			}
		}
		$locationDetails->locationAmenities 	= substr($amenityInfo,0,-1);
		
		// get the images
		if(sizeof($hotelInfo->HotelInformationResponse->HotelImages->HotelImage) > 0) {
			$i 			= 0; 
			$imageLimit = Utils::getSettingsData('max_num_img');
			foreach($hotelInfo->HotelInformationResponse->HotelImages->HotelImage as $images) {
				$locationDetails->locationGallery[] = array('image' =>$images->url,'thumbnail' => $images->thumbnailUrl );
				$i++;
				if($i >= $imageLimit) break;
				
			} 
		}
		
		$locationDetails->locationRaings		= $hotelInfo->HotelInformationResponse->HotelSummary->hotelRating;
		
		// get the room types
		if(sizeof($hotelInfo->HotelInformationResponse->RoomTypes->RoomType) > 1) {
			foreach($hotelInfo->HotelInformationResponse->RoomTypes->RoomType as $rooms) {			 
				$arrHotelInfo 					= get_object_vars($rooms);
				$roomInfo 						= new stdClass();
				$roomInfo->nAt_Id				= $arrHotelInfo['@roomCode'];
				$roomInfo->vAt_Name				= $rooms->description;			
				$locationDetails->roomTypes[] 	= $roomInfo;
			}	
		}
		else if(sizeof($hotelInfo->HotelInformationResponse->RoomTypes->RoomType) == 1) {
				$rooms = $hotelInfo->HotelInformationResponse->RoomTypes->RoomType;
				$arrHotelInfo 					= get_object_vars($rooms);
				$roomInfo 						= new stdClass();
				$roomInfo->nAt_Id				= $arrHotelInfo['@roomCode'];
				$roomInfo->vAt_Name				= $rooms->description;			
				$locationDetails->roomTypes[] 	= $roomInfo;
		}
		return $locationDetails;
	}
	
	
/*
 	 * function to make expedia payment
 	 */
	public static function doExpediapayment($bookingInfo)
	{

				 
		$expediaSettings = Apisearch::getExpediaSettings();
		
	  
		/*
		// code to find the rate key
		$getRateKey = 'http://api.ean.com/ean-services/rs/hotel/v3/avail?minorRev='.$expediaSettings['minorRev'].'&cid='.$expediaSettings['cid'].'&apiKey='.$expediaSettings['apiKey'].'&customerUserAgent=&customerIpAddress=&customerSessionId=&locale='.$expediaSettings['locale'].'&currencyCode='.$expediaSettings['currencyCode'].'&hotelId='.$bookingInfo['hotelId'].'&arrivalDate='.$bookingInfo['arrivalDate'].'&departureDate='.$bookingInfo['departureDate'].'&includeDetails=true&includeRoomImages=true&room1='.$bookingInfo['room1'];
		$info 		= file_get_contents($getRateKey); 
		$info 		= json_decode($info);
		$bookingInfo['rateKey'] 	= $info->HotelRoomAvailabilityResponse->rateKey;

		
		
		if(sizeof($info->HotelRoomAvailabilityResponse->HotelRoomResponse) > 1)	{
			$bookingInfo['roomType'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->roomTypeCode;
		  	$bookingInfo['rateCode'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->rateCode;
		}
		else {
			$bookingInfo['roomType'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse->roomTypeCode;
			$bookingInfo['rateCode'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse->rateCode;
		}
		// rate key finding code ends
		$bookingInfo['sessionID']    = $info->HotelRoomAvailabilityResponse->customerSessionId;
	*/
	    $bookData = array(
	        "sessionID" 	=> $bookingInfo['sessionID'], 
	        "currency" 		=> $expediaSettings['currencyCode'],
	        "locale" 		=> $expediaSettings['locale'],
	        "hotelID" 		=> $bookingInfo['hotelId'],
	        "arrivalDate" 	=> $bookingInfo['arrivalDate'],
	        "departureDate" => $bookingInfo['departureDate'],
	        "supplierType" 	=> "E",
	        "rateKey" 		=> $bookingInfo['rateKey'],
	        "roomType" 		=> $bookingInfo['roomType'],
	        "rateCode" 		=> $bookingInfo['rateCode'],
	        "chargeableRate"=> $bookingInfo['chargeableRate'],
	        "Adults" 		=> $bookingInfo['Adults'],
	        "Children" 		=> $bookingInfo['Children'],
	        "ChildAge" 		=> '',
	        "firstName" 	=> $bookingInfo['firstName'],
	        "lastName" 		=> $bookingInfo['lastName'],
	        "bedTypeID" 	=> $bookingInfo['bedTypeID'],
	        "smoking" 		=> $bookingInfo['smoking'], 
	        "eMail" 		=> $bookingInfo['eMail'], 
	        "address1" 		=> $bookingInfo['address1'],
	        "city" 			=> $bookingInfo['city'],
	        "state" 		=> $bookingInfo['state'], 
	        "countryCode" 	=> $bookingInfo['countryCode'],
	        "postCode" 		=> $bookingInfo['postCode'],
	        "homePhone" 	=> $bookingInfo['homePhone'],
	        "workPhone" 	=> $bookingInfo['workPhone']
	    );
	    
	    //Payment Data from SECURE Payment Forms
	    $paymentData = array (
	        "firstName" 	=> strtolower($bookingInfo['firstName']),
	        "lastName" 		=> strtolower($bookingInfo['lastName']),
	        "ccType" 		=> $bookingInfo['ccType'],  
	        "ccNumber" 		=> $bookingInfo['ccNumber'],  
	        "expiryMonth" 	=> $bookingInfo['expiryMonth'],
	        "expiryYear" 	=> $bookingInfo['expiryYear'],
	        "ccIdentifier" 	=> $bookingInfo['ccIdentifier'],
	    );
	    
    
	    $bookingResponse = Booking::doExpediaBooking($bookData, $paymentData,$expediaSettings);
		 //echopre($bookingResponse);
	    if ($bookingResponse->processedWithConfirmation == true ) {				// booking is success
	    	$status['success'] 			= 1;
	    	$status['TransactionId']	=  $bookingResponse->itineraryId;
	    	//echo "Confirmation Number number :" . $bookingResponse->confirmationNumbers .'<br>';
	    } 
	    else {		// booking is failure
			$status['success'] = 0;
	    }
	    return $status;
	    
	}
	
}

?>
