<?php 

/*
 *  This logic file includes functions for all payment gatesway processing in the reservelogic 2.0.
 */
 
class Payments
{
	
/*
 * Authorise.net payment gateway.
 */

 public static function authorize($arrPaymentInfo, $overrideAuthorizeTransMode = FALSE)
 {
 
  // Including the authorize payment file.

   PageContext::includePath('paymentgateways/authorize');
   $authorizeObj   = new  Authorize_class();
        
   // Get the authorize payment settings.

   $paySettings 	= Payments::getAuthorizeSettings();                  
   $authorizeInfo 	= array();

  // Assign the authorize payment settings values.

   $authorizeInfo['x_login'] 			= $paySettings['authorizeLoginId'];
   $authorizeInfo['x_tran_key'] 		= $paySettings['authorizeTransKey'];
   $authorizeInfo['email'] 			= $paySettings['authorizeEmail'];
   $authorizeInfo['testMode'] 			= $paySettings['authorizeTestMode'];
        
  // Assign the user information and card details.

   $authorizeInfo['desc'] 			= $arrPaymentInfo['desc'];
   $authorizeInfo['currency_code'] 	        = $arrPaymentInfo['Currency'];
   $authorizeInfo['amount'] 			= $arrPaymentInfo['amount'];
   $authorizeInfo['expMonth'] 			= $arrPaymentInfo['expMonth'];
   $authorizeInfo['expYear'] 			= $arrPaymentInfo['expYear'];
   $authorizeInfo['cvv'] 			= $arrPaymentInfo['cvv'];
   $authorizeInfo['ccno'] 			= $arrPaymentInfo['ccno'];
   $authorizeInfo['fName'] 			= $arrPaymentInfo['fName'];
   $authorizeInfo['lName'] 			= $arrPaymentInfo['lName'];
   $authorizeInfo['add1'] 			= $arrPaymentInfo['add1'];
   $authorizeInfo['city'] 			= $arrPaymentInfo['city'];
   $authorizeInfo['state'] 			= $arrPaymentInfo['state'];
   $authorizeInfo['country'] 			= $arrPaymentInfo['country'];
   $authorizeInfo['zip'] 			= $arrPaymentInfo['zip'];

   $settings                                    = Apputils::loadSettings();

   if($overrideAuthorizeTransMode){
            $return 	= $authorizeObj->submit_authorize_post($authorizeInfo);
   }else{
        if($settings['AuthorizeTransMode'] == 'AUTH_ONLY')  // If auth only , we should capture the amount at a later point
            $return 	= self::authoriseFutureCaptureFromAuthorizeNet($authorizeInfo);   
        else
            $return 	= $authorizeObj->submit_authorize_post($authorizeInfo);
   }

   $details 	                                = $return[0];
   $transaction_id                              = $return[1];


   switch ($details)
   {
       case "1": // Credit card successfully charged.
       $paymentsuccessful 	                = 1;
       $transactionid 		                = $return[6];
       break;

       case "2":// Invalid credit card.
       $paymentsuccessful 	                = 0;
       $paymenterror 		                = 'The card has been declined <br />' . $return[3];
       $transactionid 		                = NULL;
       break;

       case "4":
       $paymentsuccessful 	                = 0;
       $paymenterror 		                = 'The card has been held for review<br /> ' . $return[3];
       $transactionid 		                = NULL;
       break;

       default: // Credit card not successfully charged.
       $paymentsuccessful 	               = 0;
       $paymenterror 		               = 'Error <br />' . $return[3];
       $transactionid 		               = NULL;
       break;

    }
        
    $paymentResult['Amount'] 		= $dataArr['amount'];
    $paymentResult['success'] 		= $paymentsuccessful;
    $paymentResult['Message'] 		= $paymenterror;
    $paymentResult['TransactionId']     = $transactionid;

    return $paymentResult;
    
 }
	


	/*
	 * function to get the authorize settings
	 */
 public static function getAuthorizeSettings()
 {
   $dbObj 		= new Db();
   $paySettings 	= array();

   $paySettings['authorizeEnable']     =   $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='cenable_authorize'");
   $paySettings['authorizeLoginId']    =   $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vauthorize_loginid'");
   $paySettings['authorizeTransKey']   =   $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vauthorize_transkey'");
   $paySettings['authorizeEmail']      =   $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vauthorize_email'");
   $paySettings['authorizeTestMode']   =   $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vauthorize_test_mode'");
   
   return $paySettings;
   
 }
	
	
	
 /*
  * function to do the google checkout
  */

 public static function doGoogleCheckOut($arrGcheckOut = array())
 {
     PageContext::includePath('paymentgateways/googlecheckout');
     $gCheckoutSettings = self::getGoogleCheckoutSettings();
			     
    //Check out parameters.

      $arrGoogleCheckOut                                        = array();
      
      $arrGoogleCheckOut['merchant_id'] 			= $gCheckoutSettings['gcheck_merchant_id'];
      $arrGoogleCheckOut['merchant_id'] 			= '643760143118924';
      $arrGoogleCheckOut['merchant_key'] 			= $gCheckoutSettings['gcheck_merchant_key'];
      $arrGoogleCheckOut['merchant_key'] 			= 'jk0ACPM8RdntndpuFbqjew';
      $arrGoogleCheckOut['server_type'] 			= $gCheckoutSettings['gcheck_server_type'];
      $arrGoogleCheckOut['currency'] 				= $gCheckoutSettings['gcheck_currency'];
      $arrGoogleCheckOut['btn_checkout'] 			= $gCheckoutSettings['gcheck_btn_checkout'];
      $arrGoogleCheckOut['url_edit_cart'] 		        = $arrGcheckOut['url_edit_cart'];
      $arrGoogleCheckOut['url_continue_shopping']               = $arrGcheckOut['url_continue_shopping'];
      $arrGoogleCheckOut['items'] 				= $arrGcheckOut['items'];
      
      	
     // create the object and initialise the google checkout.

      $gCheck 	= new GoogleCheckOut();
      $display 	= $gCheck->initiator($arrGoogleCheckOut);
      return $display;
 }
	
	
 /*
  * function to get google checkout informations
  */
 public static function getGoogleCheckoutSettings()
 {
   $dbObj 			          = new Db();
   $paySettings 	                  = array();

   $paySettings['gcheck_merchant_id'] 	  = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='googleid'");
   $paySettings['gcheck_merchant_key']    = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='googlekey'");
   $paySettings['gcheck_server_type'] 	  = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='enablegooglesandbox'");
   $paySettings['gcheck_currency'] 	  = DEFAULT_CURRENCY_CODE;
   $paySettings['gcheck_btn_checkout']    = 'SMALL';

   return $paySettings;
 }
	
	
 public static function paypal($arrtwoPaySettings = array())
 {

   PageContext::includePath('paymentgateways/paypal');
                
   $p = new paypal_class;
                
   if($arrtwoPaySettings['Testmode'] == 'Y')
   {
      $paypalurl 		= "https://www.sandbox.paypal.com/cgi-bin/webscr";
      $paypalbuttonurl 	= "https://www.sandbox.paypal.com/en_US/i/btn/x-click-but23.gif" ;
   }
   else
   {
      $paypalurl 		= "https://www.paypal.com/cgi-bin/webscr";
      $paypalbuttonurl 	= "https://www.paypal.com/en_US/i/btn/x-click-but23.gif" ;
   }

   $p->paypal_url 		= $paypalurl;
   

   $p->add_field('business',$arrtwoPaySettings['Paypalemail']);
   $p->add_field('return',$arrtwoPaySettings['resultURL']);
   $p->add_field('cancel_return',$arrtwoPaySettings['cancelURL']);
   $p->add_field('notify_url',$arrtwoPaySettings['notifyURL']);
   $p->add_field('item_name',$arrtwoPaySettings['Itemname']);
   $p->add_field('amount',$arrtwoPaySettings['Grandtotal']);
   $p->add_field('custom',$arrtwoPaySettings['BookingId']);
   $p->add_field('currency_code',$arrtwoPaySettings['Currency']);
   //$p->add_field('invoice',date('YmdHis'));
   
    
 	return $p->submit_paypal_post();

 }
	
	
	/*
	 * function to get the paypal settings
	 */
	
	public static function getPaypalSettings()
    {
        
              $dbObj 		        = new Db();

              $paySettings 	= array();
              //$paySettings['Paypalidentitytoken'] 	        = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypalidentitytoken'");
              $paySettings['Paypalemail'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypalemail'");
              $paySettings['Paypaltestmode'] 		= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypal_test_mode'");

              if($paySettings['Paypaltestmode'] =="YES")
                 $paySettings['Paypaltestmode'] 	        = "Y";

              $paySettings['Paypalenable'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='cenable_paypal'");
              return $paySettings;

	}
	
	
	
	
	
	
	
	
	
	/*
	 * function to get your pay account details
	 */
	public static function getYourPaySettings()
	{
		$dbObj 			= new Db();
		$paySettings 	= array();
		$paySettings['yourpay_storeid'] 	    = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='urpaystoreid'");
        $paySettings['yourpay_demo'] 			= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='urpaydemo'");
        $paySettings['yourpay_pemfile'] 		= $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='pemfolder'");
		return $paySettings;	
	}
        public static function getPaypalproSettings()
	{
		$dbObj 			= new Db();
		$paypalproSettings 	= array();
		$paypalproSettings['username'] 	    = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypalprousername'");
                $paypalproSettings['password']      = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypalpropassword'");
                $paypalproSettings['signature']     = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypalprosignature'");
		$paypalproSettings['testMode']      = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='vpaypal_pro_test_mode'");
                return $paypalproSettings;	
	}
	
	public static function getBluepaySettings()
	{
		$dbObj 			= new Db();
		$bluepaySettings 	= array();
		$bluepaySettings['payid'] 	    = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='bluepaypayid'");
                $bluepaySettings['secretkey']      = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='bluepaysecretkey'");
                $bluepaySettings['demo']     = $dbObj->selectRow("lookup","vLookUp_Value","vLookUp_Name='bluepaydemo'");
		
                return $bluepaySettings;	
	}
	
	
	
	/*
	 * your pay payment gateway
	 */
	public static function doYourPay($arrYourPay=array())
	{
		PageContext::includePath('paymentgateways/yourpay');
		
		$myorder["port"]       	= "1129";
		$myorder["keyfile"]    	= $arrYourPay['keyfile'];
		
	 	$myorder["configfile"] 	= urlencode($arrYourPay['yourpay_storeid']);       
		$myorder["ordertype"]   = $arrYourPay['ordertype'];
		
    	if($arrYourPay['yourpay_demo'] =="YES"){
    		$myorder["host"] 	= "staging.linkpt.net";
	  		$myorder["result"]  = "GOOD";# For a test, set result to GOOD, DECLINE, or DUPLICATE
		}else{
			$myorder["host"]    = "secure.linkpt.net";
	  		$myorder["result"]  = "LIVE";
		}

    	$myorder["cardnumber"]  = $arrYourPay['yp_cardno'];
		$myorder["cardexpmonth"]= $arrYourPay['yp_expm'] ;
		$myorder["cardexpyear"] = $arrYourPay['yp_expy'];
		$myorder["chargetotal"] = urlencode($arrYourPay['userinfo']['amount']);
		 
		$myorder["name"]     	= urlencode($arrYourPay['userinfo']['fName'])." ".urlencode($arrYourPay['userinfo']['lName']);
		$myorder["company"]  	= $arrYourPay['userinfo']['company'];
		$myorder["address1"] 	= urlencode($arrYourPay['userinfo']['add1']);
		$myorder["city"]     	= urlencode($arrYourPay['userinfo']['city']);
		$myorder["state"]    	= urlencode($arrYourPay['userinfo']['state']);
		$myorder["country"]  	= urlencode($arrYourPay['userinfo']['country']);
		$myorder["phone"]    	= urlencode($arrYourPay['userinfo']['phone']);
		$myorder["email"]    	= urlencode($arrYourPay['userinfo']['email']);
		$myorder["debugging"] 	= YOURPAY_DEBUGGING_VALUE;  # for development only - not intended for production use
	
                $yourpay 	= new YourpayComponent();  
 		$result 	= $yourpay->curl_process($myorder);  # use curl methods

		return $result;
	}
	
	
	public static function doPaypalpro($arrPaypalPro=array())
	{
            
		PageContext::includePath('paymentgateways/paypalpro');
                
		$account =array();
		
		//$myorder["debugging"] 	= YOURPAY_DEBUGGING_VALUE;  # for development only - not intended for production use
	
                $myorder["name"]     	= urlencode($arrPaypalPro['userinfo']['fName'])." ".urlencode($arrPaypalPro['userinfo']['lName']);
		//$myorder["company"]  	= $arrPaypalPro['userinfo']['company'];
		$myorder["address1"] 	= urlencode($arrPaypalPro['userinfo']['add1']);
		$myorder["city"]     	= urlencode($arrPaypalPro['userinfo']['city']);
		$myorder["state"]    	= urlencode($arrPaypalPro['userinfo']['state']);
		$myorder["country"]  	= urlencode($arrPaypalPro['userinfo']['country']);
		$myorder["phone"]    	= urlencode($arrPaypalPro['userinfo']['phone']);
		$myorder["email"]    	= urlencode($arrPaypalPro['userinfo']['email']);
                $myorder["zip"]    	= urlencode($arrPaypalPro['userinfo']['zip']);
               
                $myorder['PAYMENTACTION'] = urlencode('Sale');
                $myorder['AMT'] = urlencode($arrPaypalPro['userinfo']['amount']);
                $myorder['CREDITCARDTYPE'] = $arrPaypalPro['card_type'];
                $myorder['ACCT'] = urlencode($arrPaypalPro['pp_cardno']);
                $myorder['CURRENCYCODE'] = DEFAULT_CURRENCY_CODE;
                $myorder['EXPDATE'] = $arrPaypalPro["pp_expm"].$arrPaypalPro["pp_expy"];
                $myorder['CVV2'] = $arrPaypalPro['pp_cvno'];
                $account['username'] = $arrPaypalPro['API_UserName'];
                $account['password'] = $arrPaypalPro['API_Password'];
                $account['signature'] = $arrPaypalPro['API_Signature'];
               
                if($arrPaypalPro['testMode'] == 'YES')
                    $account['environment'] = 'sandbox';
                else 
                    $account['environment'] = '';

            
                $paypalpro	= new PaypalproComponent();  
 		$result 	= $paypalpro->submitPaymentDisplay($myorder, $account);  # use curl methods
                

		return $result;
	}
        
        
	public static function dobluepay($arrBluePay=array())
	{
            
		PageContext::includePath('paymentgateways/bluepay');
                
		$account =array();
		
		//$myorder["debugging"] 	= YOURPAY_DEBUGGING_VALUE;  # for development only - not intended for production use
	
                $myorder["NAME1"]     	= urlencode($arrBluePay['userinfo']['fName'])." ".urlencode($arrBluePay['userinfo']['lName']);
		//$myorder["company"]  	= $arrBluePay['userinfo']['company'];
		$myorder["address1"] 	= urlencode($arrBluePay['userinfo']['add1']);
		$myorder["city"]     	= urlencode($arrBluePay['userinfo']['city']);
		$myorder["state"]    	= urlencode($arrBluePay['userinfo']['state']);
		$myorder["country"]  	= urlencode($arrBluePay['userinfo']['country']);
		$myorder["phone"]    	= urlencode($arrBluePay['userinfo']['phone']);
		$myorder["email"]    	= urlencode($arrBluePay['userinfo']['email']);
                $myorder["zip"]    	= urlencode($arrBluePay['userinfo']['zip']);
               
                $myorder['TRANS_TYPE'] = urlencode('Sale');
                $myorder['AMOUNT'] = urlencode($arrBluePay['userinfo']['amount']);
                $myorder['CREDITCARDTYPE'] = $arrBluePay['card_type'];
                $myorder['PAYMENT_ACCOUNT'] = urlencode($arrBluePay['bp_cardno']);
                $myorder['CURRENCYCODE'] = DEFAULT_CURRENCY_CODE;
                $myorder['CARD_EXPIRE'] = $arrBluePay["bp_expm"].$arrBluePay["bp_expy"];
                $myorder['CVV2'] = $arrBluePay['bp_cvno'];
                $account['ACCOUNT_ID'] = $arrBluePay['payid'];
                $account['SECRET_KEY'] = $arrBluePay['secretkey'];
//                $account['ACCOUNT_ID'] = '100154031489';
//                $account['SECRET_KEY'] = 'WN5IEOGJ9FJOKE5O4PWXPIR86MIVJJ89';
                $account['demo'] = $arrBluePay['demo'];
//                if($arrBluePay['testMode'] == 'YES')
//                    $account['environment'] = 'sandbox';
//                else 
//                    $account['environment'] = '';

            
                $bluepay	= new BluepayComponent();  
 		$result 	= $bluepay->bp20post($myorder, $account);  # use curl methods
                
                
		return $result;
	}
	
	
	/*
	 * function to do wordpay
	 */
	public static function doworldpay($arrWorldPay = array())
	{
		
		PageContext::includePath('paymentgateways/worldpay');
		$worldpay = new Worldpay_class();
		$result = $worldpay->submit_worldpay_post($arrWorldPay);
		return $result;
	}
	
        
        
        /*Function to capture via authorize.net*/
        public static function docaptureFromAuthorizeNet($requestArray){
            $paySettings 	= Payments::getAuthorizeSettings();
                  
            $authorizeInfo 	= array();
            
            $authorizeInfo['x_login'] 			= $paySettings['authorizeLoginId'];
            $authorizeInfo['x_tran_key'] 		= $paySettings['authorizeTransKey'];
            $authorizeInfo['email'] 			= $paySettings['authorizeEmail'];
            $authorizeInfo['testMode'] 			= $paySettings['authorizeTestMode'];
            
            
            //Prior Transaction Specific Information
            $authorizeInfo['amount'] 			= $requestArray['amount'];
            $authorizeInfo['transaction_id']            = $requestArray['transactionId'];
            
            $captureDetails = self::captureFromAuthorizeNet($authorizeInfo);
            
           
            switch ($captureDetails[0]){
		case "1":
				 $returnData['status'] = true;
		break;
		case "2":
				$returnData['status'] = false;
				$returnData['message'] = " The card has been declined";
				$returnData['message'] .="<br>" . $captureDetails[3];
		break;
		case "4":
				$returnData['status'] = false;
				$returnData['message'] = "The card has been held in queque for review";
				$returnData['message'] .= "<br>" . $captureDetails[3];
		break;
		default:
				$returnData['status'] = false;
				$returnData['message'] = " Capture operation failed ";
				$returnData['message'] .= "<br>" . $captureDetails[3];
		break;
            }
            
            return $returnData;
        }
        
        
        //Function to authorise future capture [will be captured later] from authorise.net
        private static function authoriseFutureCaptureFromAuthorizeNet($authorizeInfo){
            
            $referrer =  $_SERVER["HTTP_REFERER"];
            $x_customdata = "Custom";

            $x_Login = urlencode($authorizeInfo['x_login']); // your login
            $x_tran_key = urlencode($authorizeInfo['x_tran_key']); // Tran Key

            $x_currency_code = urlencode($authorizeInfo['currency_code']);
            $x_Delim_Data = urlencode("TRUE");
            $x_Delim_Char = urlencode(",");
            $x_Encap_Char = urlencode("");
            $x_Type = urlencode("AUTH_ONLY");

            $x_ADC_Relay_Response = urlencode("FALSE");


           if($authorizeInfo['testMode'] == "Y"){
                $x_Test_Request = urlencode("TRUE"); // Remove this line of code when you are ready to go live
            }

            // Customer Information
            $x_Method = urlencode("CC");
            $x_Amount = $authorizeInfo['amount'];
            $x_Tax=0;
            $x_Freight=0;
            $x_First_Name = urlencode($authorizeInfo['fName']);
            $x_Last_Name = urlencode($authorizeInfo['lName']);
            $x_Card_Num = urlencode($authorizeInfo['ccno']);
            $ExpDate = ($authorizeInfo['expMonth'] . $authorizeInfo['expYear']);
            $x_Exp_Date = urlencode($ExpDate);
            $x_card_code = urlencode($authorizeInfo['cvv']);

            $x_Address = urlencode($authorizeInfo['add1']);
            $x_City = urlencode($authorizeInfo['city']);
            $x_State = urlencode($authorizeInfo['state']);
            $x_Zip = urlencode($authorizeInfo['zip']);
            $x_country = urlencode($authorizeInfo['country']);
            $x_Email = '';
            $x_Email_Customer = urlencode("TRUE");
            $x_Merchant_Email = urlencode($authorizeInfo['email']); //  Replace MERCHANT_EMAIL with the merchant email address

            // Build fields string to post
            $x_cust_ip = urlencode($Cust_ip);
            $x_company = urlencode($Company);
            $x_phone = urlencode($Phone);
            $x_cust_id = urlencode($Cust_id);
            $x_invno = urlencode($Inv_id);
            $x_description = urlencode($authorizeInfo['desc'])."  purchase ";

            $fields = "x_Version=3.1&x_Login=$x_Login&x_tran_key=$x_tran_key&x_Delim_Data=$x_Delim_Data&x_Delim_Char=$x_Delim_Char&x_Encap_Char=$x_Encap_Char";
            $fields .= "&x_Type=$x_Type&x_Test_Request=$x_Test_Request&x_Method=$x_Method&x_Amount=$x_Amount&x_First_Name=$x_First_Name";
            $fields .= "&x_Last_Name=$x_Last_Name&x_Card_Num=$x_Card_Num&x_Exp_Date=$x_Exp_Date&x_card_code=$x_card_code&x_Address=$x_Address&x_City=$x_City&x_State=$x_State&x_Zip=$x_Zip&x_country=$x_country&x_Email=$x_Email&x_Email_Customer=$x_Email_Customer&x_Merchant_Email=$x_Merchant_Email&x_ADC_Relay_Response=$x_ADC_Relay_Response&x_invid=$x_invid&x_cust_ip=$x_cust_ip&x_company=$x_company&x_phone=$x_phone&x_cust_id=$x_cust_id&x_invoice_num=$x_invno&x_description=$x_description&x_tax=$x_Tax&x_freight=$x_Freight";


            // Start CURL session

            $authurl="https://secure.authorize.net/gateway/transact.dll";

            if($authorizeInfo['testMode'] == "Y"){
                $authurl="https://test.authorize.net/gateway/transact.dll";
            }


            $agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)";
            $ref = $referrer;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$authurl);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_NOPROGRESS, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt($ch, CURLOPT_USERAGENT, $agent);
            curl_setopt($ch, CURLOPT_REFERER, $ref);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            $buffer = curl_exec($ch);
            curl_close($ch);
    
            $return = preg_split("/[,]+/", "$buffer"); // Splits out the buffer return into an array so . . .
            
            return $return;
        }
        
        //Function to capture amount[priorly authorised] from authorise.net
        private static function captureFromAuthorizeNet($authorizeInfo){
            
            $referrer =  $_SERVER["HTTP_REFERER"];

            $x_Login = urlencode($authorizeInfo['x_login']); // your login
            $x_tran_key = urlencode($authorizeInfo['x_tran_key']); // Tran Key
            $x_Delim_Data = urlencode("TRUE");
            $x_Delim_Char = urlencode(",");
            $x_Encap_Char = urlencode("");
            
            
            $x_Type = urlencode('PRIOR_AUTH_CAPTURE');;
            $x_ref_transid = urlencode($authorizeInfo['transaction_id']); // Prior Trnsaction Key
            $x_Amount = $authorizeInfo['amount'];
             
            $x_ADC_Relay_Response = urlencode("FALSE");


            if($authorizeInfo['testMode'] == "Y"){
                $x_Test_Request = urlencode("TRUE"); // Remove this line of code when you are ready to go live
            }
     
            // Payment Information
            $x_Method = urlencode("CC");
           
            $x_Email = '';
            $x_Email_Customer = urlencode("TRUE");
            $x_Merchant_Email = urlencode($authorizeInfo['email']); //  Replace MERCHANT_EMAIL with the merchant email address

            // Build fields string to post

            $x_cust_ip = urlencode($Cust_ip);
            $x_company = urlencode($Company);
            $x_cust_id = urlencode($Cust_id);
         
            $x_currency_code = DEFAULT_CURRENCY_CODE;
            $x_description = urlencode($authorizeInfo['desc'])."  purchase ";

            $fields = "x_Version=3.1&x_Login=$x_Login&x_tran_key=$x_tran_key&x_Delim_Data=$x_Delim_Data&x_Delim_Char=$x_Delim_Char&x_Encap_Char=$x_Encap_Char";
            $fields .= "&x_Type=$x_Type&x_Test_Request=$x_Test_Request&x_Method=$x_Method&x_Amount=$x_Amount&x_currency_code=$x_currency_code";
            $fields .= "&x_Email=$x_Email&x_Email_Customer=$x_Email_Customer&x_Merchant_Email=$x_Merchant_Email&x_ADC_Relay_Response=$x_ADC_Relay_Response
                    &x_cust_ip=$x_cust_ip&x_company=$x_company&x_cust_id=$x_cust_id&x_description=$x_description&x_ref_transid=$x_ref_transid";

            // Start CURL session

            
            $authurl="https://secure.authorize.net/gateway/transact.dll";

             if($authorizeInfo['testMode'] == "Y"){
                $authurl="https://test.authorize.net/gateway/transact.dll";
            }


            $agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$authurl);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_NOPROGRESS, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt($ch, CURLOPT_USERAGENT, $agent);
            curl_setopt($ch, CURLOPT_REFERER, $referrer);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            $buffer = curl_exec($ch);
            curl_close($ch);
           
            $return = preg_split("/[,]+/", "$buffer"); 
            

            return $return;

        }

}


?>