<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Dec 17 2012                                               |
// +----------------------------------------------------------------------+
 // +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerIndex extends BaseController
{
	/*
		construction function. we can initialize the models here
	*/
     public function init(){
        parent::init();
      	PageContext::addScript("affiliates.js");
		$this->_common	 		= new ModelCommon();
      	$this->_session         = new LibSession();
     	PageContext::addStyle('affiliates.css',true);
     	
     	PageContext::addScript('country-state.js');
     	PageContext::$response->curPage = 'affiliates';
     	
     	 
     	PageContext::$response->affiliates = Affiliates::getAffiliateSessionInfo();
     	
     	
     }

     
    public function activation($activationKey)
    { 
    	if($activationKey != ''){	
    		PageContext::$response->message  = Affiliates::handleUserActivation($activationKey);
    	}
		PageContext::registerPostAction("center-main", "activation","index","affiliates");
    }
    
     
    public function affiliatemenu()
    {
    	
    }
     
    
    
    /*
     * function to change password
     */
    public function changepassword()
    {

        // Meta Data
        Utils::getMetaContents('affiliate_change_password');
        
    	PageContext::$response->activeleftmenu = 'password';
    	
    	$affiliateUserid = Affiliates::checkLoginUser();
    	if($this->isPost('Submit')){ 
    		$userPwd = array();
      		$userPwd['txtPwdOld'] 			= PageContext::$request['txtPwdOld'];	
    		$userPwd['txtPwd'] 				= PageContext::$request['txtPwd'];
    		$userPwd['txtPwd1'] 			= PageContext::$request['txtPwd1'];
    		PageContext::$response->message = Affiliates::changePassword($userPwd,$affiliateUserid);
   
    	}
     	PageContext::addStyle('signup.css',true);
    	PageContext::addStyle('results.css',true);
     	PageContext::registerPostAction("center-left","affiliatemenu","index","affiliates");
    	PageContext::registerPostAction("center-main", "changepassword","index","affiliates");
    	
    }
    
    
    /*
     * function to reset the password
     */
    
    public function forgotpassword()
    {
        // Meta Data
        Utils::getMetaContents('affiliate_forgotpassword');
        
    	if($this->isPost('btnPwdReset')){ 
    		 $userEmail = PageContext::$request['txtEmail'];
    		 PageContext::$response->message =  Affiliates::resetPassword($userEmail);
    	}
    	PageContext::addStyle('signup.css',true);
   		PageContext::registerPostAction("center-main", "forgotpassword","index","affiliates");
 
    }
    
    
    
    
     

   
    
    /*
     * function to list the urls for affiliates
     */
    public function geturls()
    {

        // Meta Data
        Utils::getMetaContents('affiliate_geturls');
        
        PageContext::$response->affiliateUserid 		= Affiliates::checkLoginUser();
        PageContext::$response->affiliateImageLinks 	= Affiliates::getAffiliateLinks('0');	// load image links
        PageContext::$response->affiliateTextLinks 		= Affiliates::getAffiliateLinks('1'); // load text links
        PageContext::$response->sitename 				= Utils::getSettingsData('sitename');
        PageContext::$response->activeleftmenu 			= 'geturls';
        PageContext::addStyle('results.css',true);
    	PageContext::registerPostAction("center-left","affiliatemenu","index","affiliates");
     	PageContext::registerPostAction("center-main", "geturls","index","affiliates");
    }
     
     
	 /*
	 * the logined home page of the affiliate
     */
    public function home()
    {
    	
    	// Meta Data
        Utils::getMetaContents('affiliate_home');

    	PageContext::$response->activeleftmenu = 'home';
    	$userid = Affiliates::checkLoginUser();
    	
    	PageContext::$response->userInfo = Affiliates::getAffiliateSessionInfo();
    	 
    	
    	
    	PageContext::registerPostAction("center-left","affiliatemenu","index","affiliates");
     	PageContext::registerPostAction("center-main", "home","index","affiliates");
 
    }
    
    
    
    /*
    function to load the index template
    */
    public function index()
    { 

    	$affiliateUserid = Affiliates::getAffiliateSessionInfo();
    	 
     	if(isset($affiliateUserid))
    		 	$this->redirect('home');
    		 	
        // Meta Data
        Utils::getMetaContents('affiliates');
        
      	if($this->isPost('btnLogin')){ 
    		$txtEmail 		= PageContext::$request['txtUsername'];
    		$txtPwd			= PageContext::$request['txtPwd'];
    		 $loginStatus 	= Affiliates::checkLogin($txtEmail,$txtPwd);
     		 if($loginStatus['status'] == 1)
    		 	$this->redirect('home');
    		 else 
    		 	PageContext::$response->message = '<label class="error">'.$loginStatus['msg'].'</label>';
    	}
    	PageContext::$response->sitename 				= Utils::getSettingsData('sitename');
    	PageContext::$response->affiliate_percentage 	= Utils::getSettingsData('affiliate_percentage');
     	PageContext::addStyle('signup.css',true);
        PageContext::registerPostAction("center-main", "login","index","affiliates");
		
    }
    
    
  
    public function login() { }
    
    public function logout()
    {
    	$session = new LibSession();
		$session->delete('affiliateuser');
		$this->redirect('index');
    }

    
    public function register()
    {
        
        // Meta Data
        Utils::getMetaContents('affiliate_register');

        PageContext::$response->countries = Utils::getCountries(); //echopre(PageContext::$response->countries);
        
     	if($this->isPost('Submit')){ //echopre1(PageContext::$request);
                PageContext::$response->txtEmail 	= $txtEmail 		= PageContext::$request['txtEmail'];
    		$txtPwd 							= PageContext::$request['txtPwd'];	
    		$txtPwd1 							= PageContext::$request['txtPwd1'];
    		PageContext::$response->txtfname 	= $txtfname 		= PageContext::$request['txtfname'];	
    		PageContext::$response->txtlname 	= $txtlname 		= PageContext::$request['txtlname'];
    		PageContext::$response->txtAddress1 = $txtAddress1 		= PageContext::$request['txtAddress1'];
    		//PageContext::$response->txtAddress2 = $txtAddress2 		= PageContext::$request['txtAddress2'];
    		PageContext::$response->txtCity 	= $txtCity 		= PageContext::$request['txtCity'];
    		PageContext::$response->txtCountry 	= $txtCountry 		= PageContext::$request['txtCountry'];
                
    		PageContext::$response->txtState 	= $txtState 		= PageContext::$request['txtState'];	
    		PageContext::$response->txtZip 		= $txtZip 			= PageContext::$request['txtZip'];
    		PageContext::$response->txtPhone 	= $txtPhone 		= PageContext::$request['txtPhone'];		
    		//PageContext::$response->txtFax 		= $txtFax 			= PageContext::$request['txtFax'];
    		PageContext::$response->states    = Utils::getStatesByCountry($txtCountry);
    	  		
    		if($txtEmail != '' && $txtPwd != '' && $txtPwd1 != '' && $txtfname !='' &&  $txtCountry != '' && $txtState != ''  ){
    			if( $txtPwd ==   $txtPwd1){
     				if(Utils::validEmail($txtEmail)){
    					
    					// function to check whether the email exist or not
    					$userMailExist = Affiliates::checkAffEmailExist($txtEmail);
    					if(!$userMailExist)	{
    						 
    						 $arrUser = array(	"aff_email"    	=>  $txtEmail,
                           						"aff_pwd"  	=>  md5($txtPwd),		
                           						"aff_fname" 	=>  $txtfname,
                           						"aff_lname"     =>  $txtlname,
                                                                        "aff_address1"  =>  $txtAddress1,
                                                                        "aff_city"      =>  $txtCity,
                                                                        "aff_country"   =>  $txtCountry ,
                                                                        "aff_state"     =>  $txtState,
                                                                        "aff_zip"       => $txtZip,
                                                                        "aff_phone"     =>  $txtPhone ,
                                                                        "aff_regdate"   =>  time(),
                                                                        "aff_status"    => 	0  )    ;
						$aff_pwd_salt = $txtPwd;
    						$userId = Affiliates::addAffiliate($arrUser, $aff_pwd_salt);
    							$this->redirect('loginsuccess');
    						
    					}
    					else 
    						PageContext::$response->message = AFFILIATE_MSG_MAIL_EXIST;	
    				}
    				else 
    				PageContext::$response->message = AFFILIATE_MSG_INVALID_MAIL;
    			}
    			else
    			PageContext::$response->message = AFFILIATE_MSG_INVALID_PWD;
    		}
    		else 
    		PageContext::$response->message = AFFILIATE_MSG_ALL_DETAILS;
    	}else{
             PageContext::$response->states    = Utils::getStatesByCountry('US');
        }
    	
    	
    	PageContext::addScript("affiliates.js");
    	PageContext::addStyle('signup.css',true);
        PageContext::registerPostAction("center-main", "registerform","index","affiliates");
    	
    }
    
    public function registerform(){}
    
    
    
    public function loginsuccess()
    {
    	PageContext::addStyle('signup.css',true);
    	PageContext::registerPostAction("center-main", "loginsuccess","index","affiliates");
    	 
    	//exit();
    }
    

    
    /*
     * function to edit profile of the affiliate
     */
    public function profile()
    { 
    	// Meta Data
        Utils::getMetaContents('affiliate_profile');

        PageContext::$response->countries = Utils::getCountries();
    	$affiliateUserid = Affiliates::checkLoginUser();
        
    	if($this->isPost('Submit')){ 
    		$userInfo = array();
      		$userInfo['aff_fname'] 		= PageContext::$request['txtfname'];	
    		$userInfo['aff_lname'] 		= PageContext::$request['txtlname'];
    		$userInfo['aff_address1'] 	= PageContext::$request['txtAddress1'];
    		//$userInfo['aff_address2'] 	= PageContext::$request['txtAddress2'];
    		$userInfo['aff_city'] 		= PageContext::$request['txtCity'];
    		$userInfo['aff_country'] 	= PageContext::$request['txtCountry'];
    		$userInfo['aff_state'] 		= PageContext::$request['txtState'];	
    		$userInfo['aff_zip'] 		= PageContext::$request['txtZip'];
    		$userInfo['aff_phone'] 		= PageContext::$request['txtPhone'];		
    		//$userInfo['aff_fax'] 		= PageContext::$request['txtFax'];
                
    		PageContext::$response->message = Affiliates::updateAffiliate($userInfo,$affiliateUserid);
     	}
        
    	PageContext::$response->activeleftmenu = 'profile';
    	PageContext::addStyle('signup.css',true);
    	PageContext::addStyle('results.css',true);	
    	PageContext::$response->userInfo = Affiliates::getAffiliateDetails($affiliateUserid);
        PageContext::$response->states   = Utils::getStatesByCountry(PageContext::$response->userInfo->aff_country);
    	PageContext::registerPostAction("center-left","affiliatemenu","index","affiliates");
    	PageContext::registerPostAction("center-main", "profile","index","affiliates");
    }
    
    
    /*
     * function to list the registrations happens through the affiliate
     */
    public function registrations()
    {

        // Meta Data
        Utils::getMetaContents('affiliate_payment_history');
    	
    	// get the registration list
     	PageContext::$response->userActions 	= Affiliates::getUserActions("",PageContext::$response->affiliates->aff_id);   	 
     	PageContext::$response->activeleftmenu 	= 'registrations';
    	PageContext::addStyle('results.css',true);
    	PageContext::registerPostAction("center-left","affiliatemenu","index","affiliates");
     	PageContext::registerPostAction("center-main", "registrations","index","affiliates");
    	
    }
    
    
    
    
    /*
     * function to reset the password
     */
    
    public function resetpassword($resetKey)
    {
    	
    	
    	if($this->isPost('btnResetPwd')){ 
    		//Utils::echopre($_POST);
    		
    		$userInfo = array();
      		$userInfo['pwd'] 		= PageContext::$request['txtPwd'];	
    		$userInfo['pwd1'] 		= PageContext::$request['txtPwd1'];
    		$userInfo['activationkey'] 		= $resetKey;
    		
    		$resetpwdres = Affiliates::setResetPassword($userInfo);
    		if($resetpwdres['status'] == 1)
    			$this->redirect('resetpassword/success');
    		
    		//setResetPassword
    	 
    	}
     	//echo $resetKey;
    	if($resetKey != '' && $resetKey != 'success')	{
    		$userInfo = Affiliates::checkPwdResetKey($resetKey);	// check the reset key
    		if(sizeof($userInfo) <= 0)		{
    			PageContext::$response->message = AFFILIATE_RESETPWD_INVALID_ACTIVATION_KEY;
    			PageContext::$response->error 	= 1; 
    			PageContext::$response->resetKey 	= $resetKey; 
    		}
    		else
    		{
    			PageContext::$response->resetKey 	= $resetKey;
    			PageContext::$response->error 	= 2;
    		} 
    		
    	}
    	elseif($resetKey == 'success')
    	{
    		PageContext::$response->message = AFFILIATE_RESETPWD_UPDATE_SUCCESS;
    		PageContext::$response->succes 	= 3; 
    	}
    	PageContext::addStyle('signup.css',true);
    	PageContext::registerPostAction("center-main", "resetpassword","index","affiliates");
    }


    
    
    
    
    
}

?>