<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
class GooglecartComponent extends Object
{
	var $components = array('Xmlbuilder');	
	var $merchant_id;
    var $merchant_key;
    var $currency;
    var $server_url;
    var $schema_url;
    var $base_url;
    var $checkout_url;
    var $checkout_diagnose_url;
    var $request_url;
    var $request_diagnose_url;

    var $cart_expiration = "";
    var $merchant_private_data = "";
    var $edit_cart_url = "";
    var $continue_shopping_url = "";
    var $request_buyer_phone = "";
    var $merchant_calculated = "";
    var $merchant_calculations_url = "";
    var $accept_merchant_coupons = "";
    var $accept_gift_certificates = "";
    var $rounding_mode;
    var $rounding_rule;

    var $item_arr;
    var $shipping_arr;
    var $default_tax_rules_arr;
    var $alternate_tax_tables_arr;
    var $xml_data;

    //The Constructor method which requires a merchant id, merchant key
    //and the operation type(sandbox or checkout)
    function GoogleCartch($id, $key, $server_type = "sandbox", $currency = "USD") {
      $this->merchant_id = $id;
      $this->merchant_key = $key;
      $this->currency = $currency;

      if(strtolower($server_type) == "sandbox") 
        $this->server_url = "https://sandbox.google.com/checkout/";
      else
        $this->server_url=  "https://checkout.google.com/";  

      $this->schema_url = "http://checkout.google.com/schema/2";
      $this->base_url = $this->server_url."cws/v2/Merchant/" .
          $this->merchant_id;
      $this->checkout_url =  $this->base_url . "/checkout";
      $this->checkout_diagnose_url = $this->base_url . 
          "/checkout/diagnose";
      $this->request_url = $this->base_url . "/request";
      $this->request_diagnose_url = $this->base_url . 
          "/request/diagnose";

      //The item, shipping and tax table arrays are initialized
      $this->item_arr = array();
      $this->shipping_arr = array(); 
      $this->alternate_tax_tables_arr = array();
    }

    function SetCartExpiration($cart_expire) {
      $this->cart_expiration = $cart_expire;
    }

    function SetMerchantPrivateData($data) {
      $this->merchant_private_data = $data;
    }

    function SetEditCartUrl($url) {
      $this->edit_cart_url= $url;
    }

    function SetContinueShoppingUrl($url) {
      $this->continue_shopping_url = $url;
    }

    function SetRequestBuyerPhone($req) {
      $this->_SetBooleanValue('request_buyer_phone', $req, "false");
    }

    function SetMerchantCalculations($url, $tax_option = "false",
        $coupons = "false", $gift_cert = "false") {
      $this->merchant_calculations_url = $url;
      $this->_SetBooleanValue('merchant_calculated', $tax_option, "false");
      $this->_SetBooleanValue('accept_merchant_coupons', $coupons, "false");
      $this->_SetBooleanValue('accept_gift_certificates', $gift_cert, "false");
    }

    function AddItem($google_item) {
      $this->item_arr[] = $google_item;
    }

    function AddShipping($ship) {
      $this->shipping_arr[] = $ship;
    }

    function AddDefaultTaxRules($rules) {
      $this->default_tax_table = true;
      $this->default_tax_rules_arr[] = $rules;
    }

    function AddAlternateTaxTables($tax) {
      $this->alternate_tax_tables_arr[] = $tax;
    }

    function AddRoundingPolicy($mode, $rule) {
      switch ($mode) {
        case "UP":
        case "DOWN":
        case "CEILING":
        case "HALF_UP":
        case "HALF_DOWN":
        case "HALF_EVEN":
            $this->rounding_mode = $mode;
            break;
        default:
            break;
      }
      switch ($rule) {
        case "PER_LINE":
        case "TOTAL":
            $this->rounding_rule = $rule;
            break;
        default:
            break;
      }
    }

    function GetXML() {
     $this->Xmlbuilder->Xmlbuilderch();

      $this->Xmlbuilder->Push('checkout-shopping-cart',
          array('xmlns' => $this->schema_url));
      $this->Xmlbuilder->Push('shopping-cart');

      //Add cart expiration if set
      if($this->cart_expiration != "") {
        $this->Xmlbuilder->Push('cart-expiration');
        $this->Xmlbuilder->Element('good-until-date', $this->cart_expiration);
        $this->Xmlbuilder->Pop('cart-expiration');
      }

      //Add XML data for each of the items
      $this->Xmlbuilder->Push('items');
      foreach($this->item_arr as $item) {
        $this->Xmlbuilder->Push('item');
        $this->Xmlbuilder->Element('item-name', $item->item_name);
        $this->Xmlbuilder->Element('item-description', $item->item_description);
        $this->Xmlbuilder->Element('unit-price', $item->unit_price,
            array('currency' => $this->currency));
        $this->Xmlbuilder->Element('quantity', $item->quantity);
        if($item->merchant_private_item_data != '')
          $this->Xmlbuilder->Element('merchant-private-item-data',
              $item->merchant_private_item_data);
        if($item->merchant_item_id != '')
          $this->Xmlbuilder->Element('merchant-item-id', $item->merchant_item_id);
        if($item->tax_table_selector != '')
          $this->Xmlbuilder->Element('tax-table-selector', $item->tax_table_selector);
        $this->Xmlbuilder->Pop('item');
      }
      $this->Xmlbuilder->Pop('items');

     if($this->merchant_private_data != '')
        $this->Xmlbuilder->Element('merchant-private-data',
            $this->merchant_private_data);   
			
      $this->Xmlbuilder->Pop('shopping-cart');

      $this->Xmlbuilder->Push('checkout-flow-support');
      $this->Xmlbuilder->Push('merchant-checkout-flow-support');
      if($this->edit_cart_url != '')
        $this->Xmlbuilder->Element('edit-cart-url', $this->edit_cart_url);

     
      if($this->continue_shopping_url != '')
        $this->Xmlbuilder->Element('continue-shopping-url',
            $this->continue_shopping_url);

      if(count($this->shipping_arr) > 0)
        $this->Xmlbuilder->Push('shipping-methods');

      //Add the shipping methods
      foreach($this->shipping_arr as $ship) {
        //Pickup shipping handled in else part
        if($ship->type == "flat-rate-shipping" ||
            $ship->type == "merchant-calculated-shipping") {
          $this->Xmlbuilder->Push($ship->type, array('name' => $ship->name));
          $this->Xmlbuilder->Element('price', $ship->price,
              array('currency' => $this->currency));

          $shipping_restrictions = $ship->shipping_restrictions;
          if (isset($shipping_restrictions)) {
            $this->Xmlbuilder->Push('shipping-restrictions');

            if ($shipping_restrictions->allow_us_po_box === true) {
              $this->Xmlbuilder->Element('allow-us-po-box', "true");
            } else {
              $this->Xmlbuilder->Element('allow-us-po-box', "false");
            }

            //Check if allowed restrictions specified
            if($shipping_restrictions->allowed_restrictions) {
              $this->Xmlbuilder->Push('allowed-areas');
              if($shipping_restrictions->allowed_country_area != "")
                $this->Xmlbuilder->Element('us-country-area','',
                    array('country-area' =>
                    $shipping_restrictions->allowed_country_area));
              foreach($shipping_restrictions->allowed_state_areas_arr as $current) {
                $this->Xmlbuilder->Push('us-state-area');
                $this->Xmlbuilder->Element('state', $current);
                $this->Xmlbuilder->Pop('us-state-area');
              }
              foreach($shipping_restrictions->allowed_zip_patterns_arr as $current) {
                $this->Xmlbuilder->Push('us-zip-area');
                $this->Xmlbuilder->Element('zip-pattern', $current);
                $this->Xmlbuilder->Pop('us-zip-area');
              }
              if($shipping_restrictions->allowed_world_area === true) {
                $this->Xmlbuilder->EmptyElement('world-area');
              }
              for($i=0; $i<count($shipping_restrictions->allowed_country_codes_arr); $i++) {
                $this->Xmlbuilder->Push('postal-area');
                $country_code = $shipping_restrictions->allowed_country_codes_arr[$i];
                $postal_pattern = $shipping_restrictions->allowed_postal_patterns_arr[$i];
                $this->Xmlbuilder->Element('country-code', $country_code);
                if ($postal_pattern != "") {
                  $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
                }
                $this->Xmlbuilder->Pop('postal-area');
              }
              $this->Xmlbuilder->Pop('allowed-areas');
            }

            if($shipping_restrictions->excluded_restrictions) { 
              if (!$shipping_restrictions->allowed_restrictions) {
                $this->Xmlbuilder->EmptyElement('allowed-areas');
              }
              $this->Xmlbuilder->Push('excluded-areas');
              if($shipping_restrictions->excluded_country_area != "")
                $this->Xmlbuilder->Element('us-country-area','',
                    array('country-area' => 
                    $shipping_restrictions->excluded_country_area));
              foreach($shipping_restrictions->excluded_state_areas_arr as $current) {
                $this->Xmlbuilder->Push('us-state-area');
                $this->Xmlbuilder->Element('state', $current);
                $this->Xmlbuilder->Pop('us-state-area');
              }
              foreach($shipping_restrictions->excluded_zip_patterns_arr as $current) {
                $this->Xmlbuilder->Push('us-zip-area');
                $this->Xmlbuilder->Element('zip-pattern', $current);
                $this->Xmlbuilder->Pop('us-zip-area');
              }
              for($i=0; $i<count($shipping_restrictions->excluded_country_codes_arr); $i++) {
                $this->Xmlbuilder->Push('postal-area');
                $country_code = $shipping_restrictions->excluded_country_codes_arr[$i];
                $postal_pattern = $shipping_restrictions->excluded_postal_patterns_arr[$i];
                $this->Xmlbuilder->Element('country-code', $country_code);
                if ($postal_pattern != "") {
                  $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
                }
                $this->Xmlbuilder->Pop('postal-area');
              }
              $this->Xmlbuilder->Pop('excluded-areas');
            }
            $this->Xmlbuilder->Pop('shipping-restrictions');
          }

          if ($ship->type == "merchant-calculated-shipping") {
            $address_filters = $ship->address_filters;
            if (isset($address_filters)) {
              $this->Xmlbuilder->Push('address-filters');

              if ($address_filters->allow_us_po_box === true) {
                $this->Xmlbuilder->Element('allow-us-po-box', "true");
              } else {
                $this->Xmlbuilder->Element('allow-us-po-box', "false");
              }

              //Check if allowed restrictions specified
              if($address_filters->allowed_restrictions) {
                $this->Xmlbuilder->Push('allowed-areas');
                if($address_filters->allowed_country_area != "")
                  $this->Xmlbuilder->Element('us-country-area','',
                      array('country-area' =>
                      $address_filters->allowed_country_area));
                foreach($address_filters->allowed_state_areas_arr as $current) {
                  $this->Xmlbuilder->Push('us-state-area');
                  $this->Xmlbuilder->Element('state', $current);
                  $this->Xmlbuilder->Pop('us-state-area');
                }
                foreach($address_filters->allowed_zip_patterns_arr as $current) {
                  $this->Xmlbuilder->Push('us-zip-area');
                  $this->Xmlbuilder->Element('zip-pattern', $current);
                  $this->Xmlbuilder->Pop('us-zip-area');
                }
                if($address_filters->allowed_world_area === true) {
                  $this->Xmlbuilder->EmptyElement('world-area');
                }
                for($i=0; $i<count($address_filters->allowed_country_codes_arr); $i++) {
                  $this->Xmlbuilder->Push('postal-area');
                  $country_code = $address_filters->allowed_country_codes_arr[$i];
                  $postal_pattern = $address_filters->allowed_postal_patterns_arr[$i];
                  $this->Xmlbuilder->Element('country-code', $country_code);
                  if ($postal_pattern != "") {
                    $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
                  }
                  $this->Xmlbuilder->Pop('postal-area');
                }
                $this->Xmlbuilder->Pop('allowed-areas');
              }

              if($address_filters->excluded_restrictions) { 
                if (!$address_filters->allowed_restrictions) {
                  $this->Xmlbuilder->EmptyElement('allowed-areas');
                }
                $this->Xmlbuilder->Push('excluded-areas');
                if($address_filters->excluded_country_area != "")
                  $this->Xmlbuilder->Element('us-country-area','',
                      array('country-area' => 
                      $address_filters->excluded_country_area));
                foreach($address_filters->excluded_state_areas_arr as $current) {
                  $this->Xmlbuilder->Push('us-state-area');
                  $this->Xmlbuilder->Element('state', $current);
                  $this->Xmlbuilder->Pop('us-state-area');
                }
                foreach($address_filters->excluded_zip_patterns_arr as $current) {
                  $this->Xmlbuilder->Push('us-zip-area');
                  $this->Xmlbuilder->Element('zip-pattern', $current);
                  $this->Xmlbuilder->Pop('us-zip-area');
                }
                for($i=0; $i<count($address_filters->excluded_country_codes_arr); $i++) {
                  $this->Xmlbuilder->Push('postal-area');
                  $country_code = $address_filters->excluded_country_codes_arr[$i];
                  $postal_pattern = $address_filters->excluded_postal_patterns_arr[$i];
                  $this->Xmlbuilder->Element('country-code', $country_code);
                  if ($postal_pattern != "") {
                    $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
                  }
                  $this->Xmlbuilder->Pop('postal-area');
                }
                $this->Xmlbuilder->Pop('excluded-areas');
              }
              $this->Xmlbuilder->Pop('address-filters');
            }
          }
          $this->Xmlbuilder->Pop($ship->type);
        }
        else if ($ship->type == "pickup") {
          $this->Xmlbuilder->Push('pickup', array('name' => $ship->name));
          $this->Xmlbuilder->Element('price', $ship->price, 
              array('currency' => $this->currency));
          $this->Xmlbuilder->Pop('pickup');
        }
      }
      if(count($this->shipping_arr) > 0)
        $this->Xmlbuilder->Pop('shipping-methods');

      if($this->request_buyer_phone != "")
        $this->Xmlbuilder->Element('request-buyer-phone-number', 
            $this->request_buyer_phone);

      if($this->merchant_calculations_url != "") {
        $this->Xmlbuilder->Push('merchant-calculations');
        $this->Xmlbuilder->Element('merchant-calculations-url', 
            $this->merchant_calculations_url);
        if($this->accept_merchant_coupons != "")
          $this->Xmlbuilder->Element('accept-merchant-coupons', 
              $this->accept_merchant_coupons);
        if($this->accept_gift_certificates != "")
          $this->Xmlbuilder->Element('accept-gift-certificates', 
              $this->accept_gift_certificates);
        $this->Xmlbuilder->Pop('merchant-calculations');
      }

      //Set Default and Alternate tax tables
      if( (count($this->alternate_tax_tables_arr) != 0) || (count($this->default_tax_rules_arr) != 0)) {
        if($this->merchant_calculated != "")
          $this->Xmlbuilder->Push('tax-tables', array('merchant-calculated' => $this->merchant_calculated));
        else
          $this->Xmlbuilder->Push('tax-tables');

        if(count($this->default_tax_rules_arr) != 0) {
          $this->Xmlbuilder->Push('default-tax-table');
          $this->Xmlbuilder->Push('tax-rules');
          foreach($this->default_tax_rules_arr as $curr_rule) {

            if($curr_rule->country_area != "") {
              $this->Xmlbuilder->Push('default-tax-rule');
              $this->Xmlbuilder->Element('shipping-taxed', $curr_rule->shipping_taxed);
              $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
              $this->Xmlbuilder->Push('tax-area');
              $this->Xmlbuilder->Element('us-country-area','', array('country-area' => $curr_rule->country_area));
              $this->Xmlbuilder->Pop('tax-area');
              $this->Xmlbuilder->Pop('default-tax-rule');
            }

            foreach($curr_rule->state_areas_arr as $current) {
              $this->Xmlbuilder->Push('default-tax-rule');
              $this->Xmlbuilder->Element('shipping-taxed', $curr_rule->shipping_taxed);
              $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
              $this->Xmlbuilder->Push('tax-area');
              $this->Xmlbuilder->Push('us-state-area');
              $this->Xmlbuilder->Element('state', $current);
              $this->Xmlbuilder->Pop('us-state-area');
              $this->Xmlbuilder->Pop('tax-area');
              $this->Xmlbuilder->Pop('default-tax-rule');
            }

            foreach($curr_rule->zip_patterns_arr as $current) {
              $this->Xmlbuilder->Push('default-tax-rule');
              $this->Xmlbuilder->Element('shipping-taxed', $curr_rule->shipping_taxed);
              $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
              $this->Xmlbuilder->Push('tax-area');
              $this->Xmlbuilder->Push('us-zip-area');
              $this->Xmlbuilder->Element('zip-pattern', $current);
              $this->Xmlbuilder->Pop('us-zip-area');
              $this->Xmlbuilder->Pop('tax-area');
              $this->Xmlbuilder->Pop('default-tax-rule');
            }

            for($i=0; $i<count($curr_rule->country_codes_arr); $i++) {
              $this->Xmlbuilder->Push('default-tax-rule');
              $this->Xmlbuilder->Element('shipping-taxed', $curr_rule->shipping_taxed);
              $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
              $this->Xmlbuilder->Push('tax-area');
              $this->Xmlbuilder->Push('postal-area');
              $country_code = $curr_rule->country_codes_arr[$i];
              $postal_pattern = $curr_rule->postal_patterns_arr[$i];
              $this->Xmlbuilder->Element('country-code', $country_code);
              if ($postal_pattern != "") {
                $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
              }
              $this->Xmlbuilder->Pop('postal-area');
              $this->Xmlbuilder->Pop('tax-area');
              $this->Xmlbuilder->Pop('default-tax-rule');
            }

            if ($curr_rule->world_area === true) {
              $this->Xmlbuilder->Push('default-tax-rule');
              $this->Xmlbuilder->Element('shipping-taxed', $curr_rule->shipping_taxed);
              $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
              $this->Xmlbuilder->Push('tax-area');
              $this->Xmlbuilder->EmptyElement('world-area');
              $this->Xmlbuilder->Pop('tax-area');
              $this->Xmlbuilder->Pop('default-tax-rule');
            }
          }
          $this->Xmlbuilder->Pop('tax-rules');
          $this->Xmlbuilder->Pop('default-tax-table');
        }

        if(count($this->alternate_tax_tables_arr) != 0) {
          $this->Xmlbuilder->Push('alternate-tax-tables');
          foreach($this->alternate_tax_tables_arr as $curr_table) {
            $this->Xmlbuilder->Push('alternate-tax-table', array('standalone' => $curr_table->standalone, 'name' => $curr_table->name));
            $this->Xmlbuilder->Push('alternate-tax-rules');

            foreach($curr_table->tax_rules_arr as $curr_rule) {
              if($curr_rule->country_area != "") {
                $this->Xmlbuilder->Push('alternate-tax-rule');
                $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
                $this->Xmlbuilder->Push('tax-area');
                $this->Xmlbuilder->Element('us-country-area','', array('country-area' => $curr_rule->country_area));
                $this->Xmlbuilder->Pop('tax-area');
                $this->Xmlbuilder->Pop('alternate-tax-rule');
              }

              foreach($curr_rule->state_areas_arr as $current) {
                $this->Xmlbuilder->Push('alternate-tax-rule');
                $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
                $this->Xmlbuilder->Push('tax-area');
                $this->Xmlbuilder->Push('us-state-area');
                $this->Xmlbuilder->Element('state', $current);
                $this->Xmlbuilder->Pop('us-state-area');
                $this->Xmlbuilder->Pop('tax-area');
                $this->Xmlbuilder->Pop('alternate-tax-rule');
              }

              foreach($curr_rule->zip_patterns_arr as $current) {
                $this->Xmlbuilder->Push('alternate-tax-rule');
                $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
                $this->Xmlbuilder->Push('tax-area');
                $this->Xmlbuilder->Push('us-zip-area');
                $this->Xmlbuilder->Element('zip-pattern', $current);
                $this->Xmlbuilder->Pop('us-zip-area');
                $this->Xmlbuilder->Pop('tax-area');
                $this->Xmlbuilder->Pop('alternate-tax-rule');
              }

              for($i=0; $i<count($curr_rule->country_codes_arr); $i++) {
                $this->Xmlbuilder->Push('alternate-tax-rule');
                $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
                $this->Xmlbuilder->Push('tax-area');
                $this->Xmlbuilder->Push('postal-area');
                $country_code = $curr_rule->country_codes_arr[$i];
                $postal_pattern = $curr_rule->postal_patterns_arr[$i];
                $this->Xmlbuilder->Element('country-code', $country_code);
                if ($postal_pattern != "") {
                  $this->Xmlbuilder->Element('postal-code-pattern', $postal_pattern);
                }
                $this->Xmlbuilder->Pop('postal-area');
                $this->Xmlbuilder->Pop('tax-area');
                $this->Xmlbuilder->Pop('alternate-tax-rule');
              }

              if ($curr_rule->world_area === true) {
                $this->Xmlbuilder->Push('alternate-tax-rule');
                $this->Xmlbuilder->Element('rate', $curr_rule->tax_rate);
                $this->Xmlbuilder->Push('tax-area');
                $this->Xmlbuilder->EmptyElement('world-area');
                $this->Xmlbuilder->Pop('tax-area');
                $this->Xmlbuilder->Pop('alternate-tax-rule');
              }
            }
            $this->Xmlbuilder->Pop('alternate-tax-rules');
            $this->Xmlbuilder->Pop('alternate-tax-table');
          }
          $this->Xmlbuilder->Pop('alternate-tax-tables');
        }
        $this->Xmlbuilder->Pop('tax-tables');
      }

      if (($this->rounding_mode != "") && ($this->rounding_rule != "")) {
        $this->Xmlbuilder->Push('rounding-policy');
        $this->Xmlbuilder->Element('mode', $this->rounding_mode);
        $this->Xmlbuilder->Element('rule', $this->rounding_rule);
        $this->Xmlbuilder->Pop('rounding-policy');
      }

      $this->Xmlbuilder->Pop('merchant-checkout-flow-support');
      $this->Xmlbuilder->Pop('checkout-flow-support');
      $this->Xmlbuilder->Pop('checkout-shopping-cart');

      return $this->Xmlbuilder->GetXML();  
    }

    //Code for generating Checkout button 
    function CheckoutButtonCode($size = "large", $variant = true, $loc = "en_US") {

      $size = strtolower($size);

      switch ($size) {
        case "large":
          $width = "180";
          $height = "46";
          break;

        case "medium":
          $width = "168";
          $height = "44";
          break;

        case "small":
          $width = "160";
          $height = "43";
          break;
        
        default:
          $width = "180";
          $height = "46";
          break;
      }

      switch ($variant) {
        case true:
            $variant = "text";
            break;
        case false:
            $variant = "disabled";
            break;
        default:
            $variant = "text";
            break;
      }

      $style = "trans";
//echo $this->GetXML();exit;
      if ($variant == "text") {
        $data = "<form method=\"POST\" action=\"". $this->checkout_url . "\">
                <input type=\"hidden\" name=\"cart\" value=\"". base64_encode($this->GetXML()) ."\">
                <input type=\"hidden\" name=\"signature\" value=\"". base64_encode($this->CalcHmacSha1($this->GetXML())). "\"> 
                <input type=\"image\" name=\"Checkout\" alt=\"Checkout\" 
                src=\"". $this->server_url."buttons/checkout.gif?merchant_id=".$this->merchant_id."&w=".$width. "&h=".$height."&style=".$style."&variant=".$variant."&loc=".$loc."\" 
                height=\"".$height."\" width=\"".$width. "\" />
                </form>";
      } elseif ($variant == "disabled") {
        $data = "<img alt=\"Checkout\" 
                src=\"". $this->server_url."buttons/checkout.gif?merchant_id=".$this->merchant_id."&w=".$width. "&h=".$height."&style=".$style."&variant=".$variant."&loc=".$loc."\" 
                height=\"".$height."\" width=\"".$width. "\" />";
      }
      return $data;
    }

    //Method which returns the encrypted google cart to make sure that the carts are not tampered with
    function CalcHmacSha1($data) {
      $key = $this->merchant_key;
      $blocksize = 64;
      $hashfunc = 'sha1';
      if (strlen($key) > $blocksize) {
        $key = pack('H*', $hashfunc($key));
      }
      $key = str_pad($key, $blocksize, chr(0x00));
      $ipad = str_repeat(chr(0x36), $blocksize);
      $opad = str_repeat(chr(0x5c), $blocksize);
      $hmac = pack(
                    'H*', $hashfunc(
                            ($key^$opad).pack(
                                    'H*', $hashfunc(
                                            ($key^$ipad).$data
                                    )
                            )
                    )
                );
      return $hmac; 
    }

    //Method used internally to set true/false cart variables
    function _SetBooleanValue($string, $value, $default) {
      $value = strtolower($value);
      if($value == "true" || $value == "false")
        eval('$this->'.$string.'="'.$value.'";');
      else
        eval('$this->'.$string.'="'.$default.'";');
    }
}?>