
DROP TABLE IF EXISTS `multicart_admin_menu`;
CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(200) NOT NULL default '',
  `link` varchar(200) NOT NULL default '',
  `parent_id` smallint(4) NOT NULL default '0',
  `display_order` tinyint(4) NOT NULL default '0',
  `divname` varchar(200) NOT NULL default '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL default 'ACTIVE',
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliates`;
CREATE TABLE IF NOT EXISTS `multicart_affiliates` (
  `affiliate_id` bigint(20) unsigned NOT NULL auto_increment,
  `affiliate_name` varchar(100) default NULL,
  `password` varchar(100) default NULL,
  `first_name` varchar(100) default NULL,
  `last_name` varchar(100) default NULL,
  `address1` varchar(100) default NULL,
  `address2` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(100) default NULL,
  `country` varchar(100) default NULL,
  `zip` varchar(20) default NULL,
  `fax` varchar(100) default NULL,
  `phone` varchar(100) default NULL,
  `email` varchar(100) default NULL,
  `taxid` varchar(100) default NULL,
  `date_registered` date default NULL,
  `deleted` char(1) default 'N',
  `vapproved` char(2) NOT NULL default 'N',
  PRIMARY KEY  (`affiliate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_banner`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_banner` (
  `naff_banner_id` int(11) NOT NULL auto_increment,
  `vaff_banner_name` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`naff_banner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_payments`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_payments` (
  `affiliate_payment_id` bigint(20) unsigned NOT NULL auto_increment,
  `affiliate_id` bigint(20) default NULL,
  `order_id` int(11) NOT NULL,
  `amount_paid` double default NULL,
  `date_marked_for_payment` date default NULL,
  `payment_date` date default NULL,
  `payment_method` varchar(100) default NULL,
  `comments` text,
  PRIMARY KEY  (`affiliate_payment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_registrations`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_registrations` (
  `registration_id` bigint(20) unsigned NOT NULL auto_increment,
  `vaffiliate_currency` varchar(10) NOT NULL default '',
  `affiliate_id` bigint(20) default NULL,
  `user_id` bigint(20) default NULL,
  `order_id` int(11) NOT NULL,
  `user_name` varchar(100) default NULL,
  `user_first_name` varchar(100) default NULL,
  `user_last_name` varchar(100) default NULL,
  `user_email` varchar(100) default NULL,
  `referral_charge` double default NULL,
  `registration_date` date default NULL,
  `affiliate_payment_id` bigint(20) default NULL,
  `user_totalpurchasedamount` double default NULL,
  PRIMARY KEY  (`registration_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artists`;
CREATE TABLE IF NOT EXISTS `multicart_artists` (
  `artist_id` bigint(20) unsigned NOT NULL auto_increment,
  `artist_name` varchar(100) default NULL,
  `password` varchar(100) default NULL,
  `first_name` varchar(100) default NULL,
  `last_name` varchar(100) default NULL,
  `address1` varchar(100) default NULL,
  `address2` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(100) default NULL,
  `country` varchar(100) default NULL,
  `zip` varchar(20) default NULL,
  `fax` varchar(100) default NULL,
  `phone` varchar(100) default NULL,
  `email` varchar(100) default NULL,
  `portfolio` text,
  `commission` double default NULL,
  `taxid` varchar(100) default NULL,
  `vseller_currency` varchar(50) NOT NULL default '',
  `date_registered` date default NULL,
  `company` varchar(50) default NULL,
  `website` varchar(30) default NULL,
  `deleted` char(1) default 'N',
  `vapproved` char(2) NOT NULL default 'N',
  `defaultflatrate` float NOT NULL default '0',
  `additionalflatrate` float NOT NULL default '0',
  `sellerPlanID` int(11) NOT NULL default '0',
  `enablepaypal` char(1) NOT NULL default '',
  `enablepaypalsandbox` char(1) NOT NULL default '',
  `paypalidentitytoken` varchar(200) NOT NULL default '',
  `paypalemail` varchar(100) NOT NULL default '',
  `plan_expired` enum('Y','N') NOT NULL default 'N' COMMENT 'Whether \r\n\r\nplan expired or not',
  PRIMARY KEY  (`artist_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artists_membershipDetails`;
CREATE TABLE IF NOT EXISTS `multicart_artists_membershipDetails` (
  `artist_memID` int(11) NOT NULL auto_increment,
  `artist_id` int(11) NOT NULL default '0',
  `artist_memStartDate` date NOT NULL default '0000-00-00',
  `artist_memEndDate` date NOT NULL default '0000-00-00',
  `plan_Id` int(11) NOT NULL default '0',
  `plan_SubscriptionCharge` double NOT NULL default '0',
  `transaction_id` varchar(255) NOT NULL,
  PRIMARY KEY  (`artist_memID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artist_feedbacks`;
CREATE TABLE IF NOT EXISTS `multicart_artist_feedbacks` (
  `artist_feedback_id` int(10) unsigned NOT NULL auto_increment,
  `feedback_content` text,
  `rating` smallint(6) default NULL,
  `user_id` bigint(20) default NULL,
  `artist_id` bigint(20) default NULL,
  `date_added` date default NULL,
  `published` char(1) default 'N',
  PRIMARY KEY  (`artist_feedback_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artist_payments`;
CREATE TABLE IF NOT EXISTS `multicart_artist_payments` (
  `artist_payment_id` bigint(20) unsigned NOT NULL auto_increment,
  `artist_id` bigint(20) default NULL,
  `order_id` bigint(20) default NULL,
  `commission_percentage` double default NULL,
  `seller_order_total_amount` double NOT NULL default '0',
  `admin_commision_amount` double NOT NULL default '0',
  `total_amount` double default NULL,
  `amount_paid` double default NULL,
  `payment_method` varchar(100) default NULL,
  `comments` text,
  `date_marked_for_payment` date default NULL,
  `payment_date` date default NULL,
  `payment_status` enum('P','C') NOT NULL default 'P',
  PRIMARY KEY  (`artist_payment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artist_portfolios`;
CREATE TABLE IF NOT EXISTS `multicart_artist_portfolios` (
  `artist_portfolio_id` int(10) unsigned NOT NULL auto_increment,
  `artist_id` int(11) default NULL,
  `artist_description` text,
  `artist_photo` varchar(200) default NULL,
  `artist_sample_work_1` varchar(200) default NULL,
  `artist_sample_work_2` varchar(200) default NULL,
  `artist_sample_work_3` varchar(200) default NULL,
  `artist_sample_work_4` varchar(200) default NULL,
  `artist_sample_work_5` varchar(200) default NULL,
  `artist_sample_work_6` varchar(200) default NULL,
  PRIMARY KEY  (`artist_portfolio_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_banners`;
CREATE TABLE IF NOT EXISTS `multicart_banners` (
  `nbanner_id` int(11) NOT NULL auto_increment,
  `vbanner_name` varchar(50) NOT NULL default '',
  `vbanner_locurl` varchar(250) NOT NULL default '',
  `vbanner_image` varchar(50) NOT NULL default '',
  `dbanner_date` date NOT NULL default '0000-00-00',
  `nbanner_display_count` int(11) NOT NULL default '0',
  `vbannerdelete_status` char(1) NOT NULL default '',
  PRIMARY KEY  (`nbanner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_cart`;
CREATE TABLE IF NOT EXISTS `multicart_cart` (
  `cart_id` bigint(20) unsigned NOT NULL auto_increment,
  `user_id` bigint(11) default NULL,
  `visitor_cart_id` varchar(40) default NULL,
  `product_id` bigint(20) default NULL,
  `product_option_id` bigint(20) NOT NULL,
  `quantity` int(11) default NULL,
  `status` tinyint(4) default NULL,
  `datetime_added` varchar(20) default NULL,
  PRIMARY KEY  (`cart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_cart_temp`;
CREATE TABLE IF NOT EXISTS `multicart_cart_temp` (
  `ncart_temp_id` int(11) NOT NULL auto_increment,
  `ncart_id` int(11) NOT NULL default '0',
  `ncart_quantity` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ncart_temp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_categories`;
CREATE TABLE IF NOT EXISTS `multicart_categories` (
  `category_id` int(11) NOT NULL auto_increment,
  `category_name` varchar(100) default NULL,
  `parent_id` int(11) NOT NULL default '0',
  `route` varchar(100) default NULL,
  `count` int(11) default '0',
  `gift_certificate_flag` char(1) NOT NULL default '',
  `avatar` varchar(250) NOT NULL,
  PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_category_options`;
CREATE TABLE IF NOT EXISTS `multicart_category_options` (
  `category_option_id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL,
  `option_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`category_option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_content_management`;
CREATE TABLE IF NOT EXISTS `multicart_content_management` (
  `content_id` int(11) NOT NULL auto_increment,
  `content_name` varchar(25) NOT NULL default '',
  `content_heading` text NOT NULL,
  `content_text` text NOT NULL,
  PRIMARY KEY  (`content_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_countries`;
CREATE TABLE IF NOT EXISTS `multicart_countries` (
  `country_id` int(11) NOT NULL auto_increment,
  `country_name` varchar(64) NOT NULL default '',
  `country_iso_code_2` char(2) NOT NULL default '',
  PRIMARY KEY  (`country_id`),
  KEY `IDX_COUNTRY_NAME` (`country_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_couponcode`;
CREATE TABLE IF NOT EXISTS `multicart_couponcode` (
  `ccID` int(11) NOT NULL auto_increment,
  `ccStartDate` date NOT NULL default '0000-00-00',
  `ccEndDate` date NOT NULL default '0000-00-00',
  `ccCode` varchar(50) NOT NULL default '',
  `ccDescription` text NOT NULL,
  `ccDiscount` int(11) NOT NULL default '0',
  `subscriptionStatus` char(1) NOT NULL default '',
  `ccStatus` char(1) NOT NULL default '',
  PRIMARY KEY  (`ccID`),
  UNIQUE KEY `ccCode` (`ccCode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_currency_master`;
CREATE TABLE IF NOT EXISTS `multicart_currency_master` (
  `ncurrency_id` int(11) NOT NULL auto_increment,
  `vcurrency_name` varchar(50) NOT NULL default '',
  `vcurrency_code` varchar(10) NOT NULL default '',
  `vcurrency_symbol` varchar(10) NOT NULL default '',
  `nexchange_price` float NOT NULL default '0',
  `vactive` char(1) NOT NULL default '',
  `vcurrency_delete_status` char(1) NOT NULL default '',
  `usdollar_rate` float NOT NULL default '1',
  PRIMARY KEY  (`ncurrency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_fields`;
CREATE TABLE IF NOT EXISTS `multicart_custom_fields` (
  `ncustom_id` int(11) NOT NULL auto_increment,
  `vcustom_field_form_id` int(11) NOT NULL default '0',
  `vcustom_field_name` varchar(50) NOT NULL default '',
  `vcustom_field_type` varchar(50) NOT NULL default '',
  `vrequired_custom_field` char(1) NOT NULL default '',
  `vcustom_sort_order` int(11) NOT NULL default '0',
  `vcustom_display_field` char(1) NOT NULL default '',
  `vcustom_delete_status` char(1) NOT NULL default '',
  PRIMARY KEY  (`ncustom_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_fields_value`;
CREATE TABLE IF NOT EXISTS `multicart_custom_fields_value` (
  `nvalue_id` int(11) NOT NULL auto_increment,
  `ncustom_field_id` int(11) NOT NULL default '0',
  `ncustom_table_id` int(11) NOT NULL default '0',
  `vfield_name_value` text NOT NULL,
  PRIMARY KEY  (`nvalue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_form`;
CREATE TABLE IF NOT EXISTS `multicart_custom_form` (
  `ncustom_form_id` int(11) NOT NULL auto_increment,
  `vcustom_form_name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`ncustom_form_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_digital_product`;
CREATE TABLE IF NOT EXISTS `multicart_digital_product` (
  `ndigital_id` int(11) NOT NULL auto_increment,
  `vdigital_product_name` varchar(250) NOT NULL default '',
  `ndigital_productid` int(11) NOT NULL default '0',
  `ndigital_orderid` int(11) NOT NULL default '0',
  `vdigital_product_code` text NOT NULL,
  `ndownload_try` int(11) NOT NULL default '0',
  `ndownload_count` int(11) NOT NULL default '0',
  `ndownload_expiry` datetime NOT NULL default '0000-00-00 00:00:00',
  `ndownload_expiry_days` int(11) NOT NULL default '0',
  `ndownload_status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ndigital_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_email_templates`;
CREATE TABLE IF NOT EXISTS `multicart_email_templates` (
  `nemail_id` int(11) NOT NULL auto_increment,
  `vtemplate_name` varchar(100) NOT NULL default '',
  `vtemplate_title` varchar(100) NOT NULL default '',
  `vemail_body` text NOT NULL,
  `vreplaceable_variables` text NOT NULL,
  `vtemplate_flag` char(1) default '',
  PRIMARY KEY  (`nemail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_fedexsettings`;
CREATE TABLE IF NOT EXISTS `multicart_fedexsettings` (
  `fid` int(11) NOT NULL auto_increment,
  `FedexAccno` varchar(40) default NULL,
  `FedexMeterno` varchar(20) default NULL,
  `FedexWeight` varchar(20) default NULL,
  `FedexServer` varchar(20) default NULL,
  `FedexDropOff` varchar(100) default NULL,
  `FedexService` text,
  `FedexPassword` varchar(50) default NULL,
  `FedexKey` varchar(50) default NULL,
  `FedexPackage` varchar(50) default NULL,
  `FedexCurrency` varchar(10) default NULL,
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_feedbacks`;
CREATE TABLE IF NOT EXISTS `multicart_feedbacks` (
  `feedback_id` int(10) unsigned NOT NULL auto_increment,
  `first_name` varchar(100) default NULL,
  `last_name` varchar(100) default NULL,
  `email` varchar(100) default NULL,
  `feedback_content` text,
  `user_id` bigint(20) default NULL,
  `date_added` date default NULL,
  `published` char(1) default 'N',
  PRIMARY KEY  (`feedback_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_flat_rate_default`;
CREATE TABLE IF NOT EXISTS `multicart_flat_rate_default` (
  `flat_rate_default_id` bigint(20) NOT NULL auto_increment,
  `flat_rate_name` varchar(250) NOT NULL,
  `first_Item_charge` float NOT NULL,
  `additional_Item_charge` float NOT NULL,
  PRIMARY KEY  (`flat_rate_default_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_flat_rate_seller`;
CREATE TABLE IF NOT EXISTS `multicart_flat_rate_seller` (
  `flat_rate_seller_id` bigint(20) NOT NULL auto_increment,
  `flat_rate_name` varchar(250) NOT NULL,
  `first_Item_charge` float NOT NULL,
  `additional_Item_charge` float NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`flat_rate_seller_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_giftcertificates`;
CREATE TABLE IF NOT EXISTS `multicart_giftcertificates` (
  `gift_id` int(11) NOT NULL auto_increment,
  `vgift_coupon_code` varchar(255) NOT NULL,
  `ngift_order_id` int(11) NOT NULL,
  `ngift_coupon_amount` double NOT NULL,
  `ngift_product_id` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL,
  `nused_gift_amount` double NOT NULL default '0',
  `seller_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`gift_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_giftcoupon_master`;
CREATE TABLE IF NOT EXISTS `multicart_giftcoupon_master` (
  `ngift_id` int(11) NOT NULL auto_increment,
  `ngift_product_id` int(11) NOT NULL default '0',
  `ngift_order_id` int(11) NOT NULL default '0',
  `vgift_coupon_code` varchar(250) NOT NULL default '',
  `ngift_coupon_amount` float NOT NULL default '0',
  `ngift_coupon_products` text NOT NULL,
  `vgift_currency` varchar(10) NOT NULL default '',
  `vgift_delete_status` char(1) NOT NULL default '',
  PRIMARY KEY  (`ngift_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_help`;
CREATE TABLE IF NOT EXISTS `multicart_help` (
  `hid` int(11) NOT NULL auto_increment,
  `hcid` int(11) default NULL,
  `htitle` varchar(100) default NULL,
  `hdescription` text,
  `hposition` int(11) default NULL,
  `active` enum('0','1') default NULL,
  `himage` varchar(100) default NULL,
  PRIMARY KEY  (`hid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_helpcategory`;
CREATE TABLE IF NOT EXISTS `multicart_helpcategory` (
  `hcid` int(11) NOT NULL auto_increment,
  `htype` varchar(10) default NULL,
  `hctitle` varchar(100) default NULL,
  `hcposition` int(11) default NULL,
  `active` enum('0','1') default NULL,
  PRIMARY KEY  (`hcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_homepagebanners`;
CREATE TABLE IF NOT EXISTS `multicart_homepagebanners` (
  `homepage_banner_id` bigint(20) NOT NULL auto_increment,
  `image` varchar(250) NOT NULL,
  `deleted` enum('Y','N') NOT NULL default 'N',
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`homepage_banner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_message_to_seller`;
CREATE TABLE IF NOT EXISTS `multicart_message_to_seller` (
  `message_to_seller_id` bigint(20) NOT NULL auto_increment,
  `artist_id` int(11) NOT NULL,
  `name` varchar(250) NOT NULL,
  `email` varchar(250) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `message` text NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `read` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`message_to_seller_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_metatags`;
CREATE TABLE IF NOT EXISTS `multicart_metatags` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(200) default NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(20) default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_newsletters`;
CREATE TABLE IF NOT EXISTS `multicart_newsletters` (
  `nl_id` int(11) NOT NULL auto_increment,
  `nl_subject` varchar(200) NOT NULL default '',
  `nl_message` text NOT NULL,
  `nl_date` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nl_id`),
  UNIQUE KEY `nl_id` (`nl_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_options`;
CREATE TABLE IF NOT EXISTS `multicart_options` (
  `option_id` bigint(20) NOT NULL auto_increment,
  `option_name` varchar(250) NOT NULL,
  PRIMARY KEY  (`option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_orders`;
CREATE TABLE IF NOT EXISTS `multicart_orders` (
  `order_id` bigint(20) unsigned NOT NULL auto_increment,
  `user_id` bigint(20) default NULL,
  `billing_first_name` varchar(100) default NULL,
  `billing_last_name` varchar(100) default NULL,
  `billing_address1` varchar(100) default NULL,
  `billing_address2` varchar(100) default NULL,
  `billing_city` varchar(100) default NULL,
  `billing_state` varchar(100) default NULL,
  `billing_country` varchar(100) default NULL,
  `billing_zip` varchar(20) default NULL,
  `billing_fax` varchar(30) default NULL,
  `billing_email` varchar(100) default NULL,
  `billing_phone` varchar(20) default NULL,
  `shipping_first_name` varchar(100) default NULL,
  `shipping_last_name` varchar(100) default NULL,
  `shipping_address1` varchar(100) default NULL,
  `shipping_address2` varchar(100) default NULL,
  `shipping_city` varchar(100) default NULL,
  `shipping_state` varchar(100) default NULL,
  `shipping_country` varchar(100) default NULL,
  `shipping_zip` varchar(20) default NULL,
  `shipping_fax` varchar(20) default NULL,
  `shipping_email` varchar(100) default NULL,
  `shipping_phone` varchar(20) default NULL,
  `prefered_shippin_method` varchar(200) default NULL,
  `order_date` date default NULL,
  `order_total_price` double default NULL,
  `taxrate` double default '0',
  `couponCode` varchar(50) NOT NULL default '0',
  `couponCodeDiscount` int(11) NOT NULL default '0',
  `order_status` tinyint(4) default NULL,
  `vorder_currency` varchar(10) NOT NULL default '',
  `vpayment_status` char(1) NOT NULL default '',
  `transaction_id` varchar(255) default NULL,
  `vgiftcertificate_code` varchar(255) NOT NULL default '',
  `nused_gift_amount` double NOT NULL default '0',
  `namount_paid` double NOT NULL default '0',
  `buyer_comments` text NOT NULL,
  `payment_completed_status` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_order_details`;
CREATE TABLE IF NOT EXISTS `multicart_order_details` (
  `order_detail_id` bigint(20) unsigned NOT NULL auto_increment,
  `order_id` bigint(20) default NULL,
  `product_id` bigint(20) default NULL,
  `product_option_id` int(11) NOT NULL,
  `product_name` varchar(200) default NULL,
  `product_code` varchar(20) default NULL,
  `product_price` double default NULL,
  `product_tax` float NOT NULL,
  `product_quantity` int(11) default NULL,
  `artist_id` bigint(20) default NULL,
  `item_status` smallint(6) default NULL,
  `artist_payment_status` smallint(6) default NULL,
  `artist_payment_id` bigint(20) default NULL,
  `user_refund_id` bigint(20) default '0',
  `product_discount` int(11) default '0',
  `item_delivery_date` datetime NOT NULL,
  `product_commission_amount` float NOT NULL default '0',
  PRIMARY KEY  (`order_detail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_order_status`;
CREATE TABLE IF NOT EXISTS `multicart_order_status` (
  `order_status_id` tinyint(3) unsigned NOT NULL auto_increment,
  `order_status` varchar(100) default NULL,
  PRIMARY KEY  (`order_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_products`;
CREATE TABLE IF NOT EXISTS `multicart_products` (
  `product_id` bigint(20) unsigned NOT NULL auto_increment,
  `product_name` varchar(255) default NULL,
  `product_code` varchar(20) default NULL,
  `product_description` text,
  `product_price` double default NULL,
  `product_category` int(11) default NULL,
  `product_artist_id` int(11) default NULL,
  `date_added` date default NULL,
  `deleted` char(1) default 'N',
  `featured` char(1) default 'N',
  `vdigital_product` char(1) NOT NULL default '',
  `vapproved` char(2) NOT NULL default 'N',
  `payment_status` enum('PENDING','COMPLETED') NOT NULL default 'PENDING',
  PRIMARY KEY  (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_impression`;
CREATE TABLE IF NOT EXISTS `multicart_product_impression` (
  `product_impression_id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL,
  `ip` varchar(250) NOT NULL,
  `visited_on` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`product_impression_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_listing_fee_payment`;
CREATE TABLE IF NOT EXISTS `multicart_product_listing_fee_payment` (
  `product_listing_fee_payment_id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL,
  `total_amount` int(11) NOT NULL,
  `amount_paid` int(11) NOT NULL,
  `payment_method` varchar(250) NOT NULL,
  `payment_date` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `payment_status` enum('PENDING','COMPLETED') NOT NULL,
  PRIMARY KEY  (`product_listing_fee_payment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_options`;
CREATE TABLE IF NOT EXISTS `multicart_product_options` (
  `product_option_id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL,
  `additional_price` float NOT NULL,
  `image_small` varchar(250) NOT NULL,
  `image_big` varchar(250) NOT NULL,
  `product_stock` int(11) NOT NULL,
  `reorder_level` int(11) NOT NULL,
  `product_shipping_weight` float NOT NULL,
  `default_option` enum('YES','NO') NOT NULL default 'YES',
  `discount` float NOT NULL,
  `discount_description` varchar(250) NOT NULL,
  `product_width` int(11) NOT NULL,
  `product_height` int(11) NOT NULL,
  `product_length` int(11) NOT NULL,
  PRIMARY KEY  (`product_option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_option_values`;
CREATE TABLE IF NOT EXISTS `multicart_product_option_values` (
  `product_option_value_id` bigint(20) NOT NULL auto_increment,
  `product_option_id` bigint(20) NOT NULL,
  `option_id` bigint(20) NOT NULL,
  `value` varchar(250) NOT NULL,
  PRIMARY KEY  (`product_option_value_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_view_images`;
CREATE TABLE IF NOT EXISTS `multicart_product_view_images` (
  `nproduct_image_id` int(11) NOT NULL auto_increment,
  `nimage_productid` int(11) NOT NULL default '0',
  `vimage_name` varchar(250) NOT NULL default '',
  `vimage_description` text NOT NULL,
  `vproduct_image_delete_status` char(1) NOT NULL default '',
  PRIMARY KEY  (`nproduct_image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_rating`;
CREATE TABLE IF NOT EXISTS `multicart_rating` (
  `nrat_id` int(11) NOT NULL auto_increment,
  `vrating` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`nrat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_record_ratings`;
CREATE TABLE IF NOT EXISTS `multicart_record_ratings` (
  `nrts_id` int(11) NOT NULL auto_increment,
  `nrating_id` int(11) NOT NULL default '0',
  `nruser_id` int(11) NOT NULL default '0',
  `nrseller_id` int(11) NOT NULL default '0',
  `ntotal_ratings` int(11) NOT NULL default '0',
  `vType` char(1) NOT NULL default 's',
  `vActive` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`nrts_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_refunds`;
CREATE TABLE IF NOT EXISTS `multicart_refunds` (
  `refund_id` bigint(20) NOT NULL auto_increment,
  `seller_id` bigint(20) NOT NULL default '0',
  `buyer_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `quantity` bigint(20) default NULL,
  `return_reason` text NOT NULL,
  `Customer_Feedback` text,
  `Status` varchar(255) default NULL,
  `Additional_info` text,
  `date` date NOT NULL default '0000-00-00',
  `refund_mode` varchar(255) default NULL,
  `reference_number` varchar(255) default NULL,
  PRIMARY KEY  (`refund_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_report_product`;
CREATE TABLE IF NOT EXISTS `multicart_report_product` (
  `nreport_id` int(11) NOT NULL auto_increment,
  `nreport_product_id` int(11) NOT NULL default '0',
  `nreport_customerid` int(11) NOT NULL default '0',
  `nproduct_view_count` int(11) NOT NULL default '0',
  `dproduct_view_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`nreport_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_Review`;
CREATE TABLE IF NOT EXISTS `multicart_Review` (
  `nRId` int(11) NOT NULL auto_increment,
  `nUserId` int(11) NOT NULL default '0',
  `nProdId` int(11) NOT NULL default '0',
  `vDes` text NOT NULL,
  `vActive` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`nRId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_sellerPlans`;
CREATE TABLE IF NOT EXISTS `multicart_sellerPlans` (
  `plan_Id` int(11) NOT NULL auto_increment,
  `plan_Title` varchar(100) NOT NULL default '',
  `plan_Description` text NOT NULL,
  `plan_Period` char(1) NOT NULL default '',
  `plan_SubscriptionCharge` double NOT NULL default '0',
  `plan_Status` char(1) NOT NULL default '',
  PRIMARY KEY  (`plan_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_settings`;
CREATE TABLE IF NOT EXISTS `multicart_settings` (
  `nsettings_id` int(11) NOT NULL auto_increment,
  `vLicenceKey` varchar(250) default NULL,
  `site_name` varchar(100) default NULL,
  `site_url` varchar(250) default NULL,
  `site_secure_url` varchar(250) default NULL,
  `site_email` varchar(100) default NULL,
  `site_logo` varchar(100) default NULL,
  `vReview` varchar(9) NOT NULL default 'automatic',
  `banner_size` varchar(15) NOT NULL default '',
  `npagination_limit` int(11) NOT NULL default '0',
  `enable_google` char(1) NOT NULL default '',
  `nproduct_images` int(11) NOT NULL default '0',
  `google_adsense_value` text NOT NULL,
  `enable_shipping` char(1) NOT NULL default '',
  `enable_tax` enum('0','1','2') NOT NULL default '0',
  `enable_flatrate` varchar(10) NOT NULL default 'Y',
  `default_flatrate` float NOT NULL default '0',
  `additional_flatrate` float NOT NULL default '0',
  `defaulttax_rate` float default '0',
  `enable_fedexshipping` varchar(10) default 'N',
  `enable_uspsshipping` varchar(10) NOT NULL default 'N',
  `enable_canadapost` varchar(10) NOT NULL default 'N',
  `enable_australiapost` varchar(10) NOT NULL default 'N',
  `canada_merchantId` varchar(30) default NULL,
  `canada_server` varchar(30) default NULL,
  `more_images` char(1) NOT NULL default '',
  `ndisplay_stock` char(1) NOT NULL default '',
  `ndisplay_banner` char(1) NOT NULL default '',
  `site_style` varchar(100) default NULL,
  `admin_name` varchar(100) default NULL,
  `admin_password` varchar(100) default NULL,
  `admin_email` varchar(100) default NULL,
  `products_per_page` int(11) default NULL,
  `publish_feedbacks` char(1) default NULL,
  `publish_featured` char(1) default 'Y',
  `publish_newitem` char(1) default 'Y',
  `publish_shoppingcart` char(1) default 'Y',
  `artist_commission` smallint(6) default '0',
  `referral_charge` double default '0',
  `vauthorize_enable` char(1) NOT NULL default '',
  `venable_gift_payment` char(1) NOT NULL default '',
  `venable_couponCode_payment` char(1) NOT NULL default 'N',
  `enable_buyerToseller` char(1) NOT NULL default 'N',
  `enable_membership` char(1) NOT NULL default 'N',
  `authorize_loginid` varchar(200) default NULL,
  `authorize_transkey` varchar(200) default NULL,
  `authorize_password` varchar(200) default NULL,
  `authorize_email` varchar(200) default NULL,
  `authorize_test_mode` char(1) default NULL,
  `enablepaypal` char(1) default NULL,
  `enableworldpay` char(1) NOT NULL default 'N',
  `worldpay_testmode` enum('0','100') NOT NULL default '0',
  `worldpay_inst_Id` varchar(15) default NULL,
  `worldpay_email` varchar(30) default NULL,
  `worldpay_transact_method` enum('A','C','E','R') default NULL,
  `enablepaypalsandbox` char(1) default NULL,
  `paypalidentitytoken` varchar(200) default NULL,
  `paypalemail` varchar(100) default NULL,
  `vgoogle_check_enable` char(1) NOT NULL default '',
  `vgooglecheck_id` varchar(250) NOT NULL default '',
  `vgooglecheck_key` varchar(250) NOT NULL default '',
  `vgooglecheck_mode` varchar(10) NOT NULL default '',
  `vyourpay_enable` char(1) NOT NULL default '',
  `vyourpay_storeid` varchar(250) NOT NULL default '',
  `vyourpay_certificate_file` varchar(250) NOT NULL default '',
  `vyourpay_mode` varchar(5) NOT NULL default '',
  `approve_sellers` enum('1','2','3') NOT NULL default '1',
  `approve_affiliates` enum('1','2','3') NOT NULL default '1',
  `approve_products` enum('1','2') NOT NULL default '1',
  `enable_rma` varchar(10) NOT NULL default 'N',
  `rma_repair` varchar(10) NOT NULL default 'N',
  `rma_replace` varchar(10) NOT NULL default 'N',
  `rma_refund` varchar(10) NOT NULL default 'N',
  `rma_confirm_message` varchar(10) NOT NULL default 'N',
  `rma_status_change` varchar(10) NOT NULL default 'N',
  `enable_bulkupload` varchar(10) NOT NULL default 'N',
  `flatrate_displayname` varchar(255) NOT NULL default 'Over night ground',
  `admin_currency` varchar(255) NOT NULL default 'USD',
  `enable_multicurrency` enum('Y','N') NOT NULL default 'N',
  `slideshow_delay` int(5) NOT NULL,
  `enable_affiliates` enum('Y','N') NOT NULL default 'Y',
  `more_image_limit` int(11) NOT NULL default '4',
  `vyourpay_userid` varchar(100) NOT NULL,
  `paypal_api_username` varchar(200) NOT NULL,
  `paypal_api_password` varchar(200) NOT NULL,
  `paypal_api_signature` varchar(255) NOT NULL,
  `paypal_application_app_id` varchar(255) NOT NULL,
  `product_listing_fee` int(11) NOT NULL default '0',
  `enable_commentbox` enum('Y','N') NOT NULL default 'N',
  `vbluepay_enable` enum('Y','N') NOT NULL default 'N',
  `bluepay_accountid` varchar(255) NOT NULL,
  `bluepay_secretkey` varchar(255) NOT NULL,
  `bluepay_test_mode` enum('TEST','LIVE') NOT NULL default 'TEST',
  PRIMARY KEY  (`nsettings_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_details`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_details` (
  `nshipping_id` int(11) NOT NULL auto_increment,
  `nshipping_type` int(11) NOT NULL default '0',
  `norder_id` int(11) NOT NULL default '0',
  `nshp_productid` int(11) NOT NULL default '0',
  `nproduct_option_id` int(11) NOT NULL,
  `nshp_productname` varchar(255) NOT NULL,
  `vshipping_name` varchar(250) NOT NULL default '',
  `nshipping_cost` float NOT NULL default '0',
  `nshipping_weight` int(11) NOT NULL default '0',
  `vshipping_currency` varchar(10) NOT NULL default '',
  `dshipped_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `nshp_status` char(1) NOT NULL default '',
  `user_id` bigint(11) NOT NULL default '0',
  PRIMARY KEY  (`nshipping_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_methods`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_methods` (
  `shipping_method_id` int(10) unsigned NOT NULL auto_increment,
  `shipping_method_name` varchar(255) default NULL,
  `shipping_method_logo` varchar(255) default NULL,
  `date_created` date default NULL,
  `vdeleted` char(1) NOT NULL default '',
  PRIMARY KEY  (`shipping_method_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_settings`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_settings` (
  `sid` tinyint(11) NOT NULL auto_increment,
  `nShippingweight` int(11) NOT NULL default '0',
  `ups_rate` varchar(255) NOT NULL default '',
  `container_type` varchar(255) NOT NULL default '',
  `address_quote_method` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_social_media`;
CREATE TABLE IF NOT EXISTS `multicart_social_media` (
  `social_media_id` int(11) NOT NULL auto_increment,
  `name` varchar(250) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` text NOT NULL,
  `logo` varchar(250) NOT NULL,
  `active` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`social_media_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_subscribers`;
CREATE TABLE IF NOT EXISTS `multicart_subscribers` (
  `nl_subscribersID` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `nl_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`nl_subscribersID`),
  UNIQUE KEY `nl_subscribersID` (`nl_subscribersID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_taxrate`;
CREATE TABLE IF NOT EXISTS `multicart_taxrate` (
  `Tid` int(20) NOT NULL auto_increment,
  `taxname` varchar(255) default NULL,
  `vtaxbase` varchar(40) default NULL,
  `vCountry` varchar(255) default NULL,
  `vState` text,
  `ntaxrate` float NOT NULL default '0',
  `vtaxaddress` enum('shipping','billing') NOT NULL default 'shipping',
  `rate_enable` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`Tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_template_master`;
CREATE TABLE IF NOT EXISTS `multicart_template_master` (
  `ntemplate_id` int(11) NOT NULL auto_increment,
  `vtemplate_name` varchar(50) NOT NULL default '',
  `vtop_filename` varchar(50) NOT NULL default '',
  `vleft_filename` varchar(50) NOT NULL default '',
  `vbottom_filename` varchar(50) NOT NULL default '',
  `vimages_folder` varchar(250) NOT NULL default '',
  `vcss_name` varchar(100) NOT NULL default '',
  `vcss_original` varchar(100) NOT NULL default '',
  `vactive_status` char(1) NOT NULL default '',
  PRIMARY KEY  (`ntemplate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_users`;
CREATE TABLE IF NOT EXISTS `multicart_users` (
  `user_id` bigint(20) unsigned NOT NULL auto_increment,
  `user_name` varchar(100) default NULL,
  `password` varchar(100) default NULL,
  `first_name` varchar(100) default NULL,
  `last_name` varchar(100) default NULL,
  `address1` varchar(100) default NULL,
  `address2` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(100) default NULL,
  `country` varchar(100) default NULL,
  `phone` varchar(100) default NULL,
  `fax` varchar(100) default NULL,
  `zip` varchar(20) default NULL,
  `email` varchar(100) default NULL,
  `date_registered` date default NULL,
  `affiliate_id` bigint(20) default NULL,
  `deleted` char(1) default 'N',
  `newsLetter` char(1) NOT NULL default 'N',
  `vaff_type` varchar(10) default NULL,
  PRIMARY KEY  (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_usps_settings`;
CREATE TABLE IF NOT EXISTS `multicart_usps_settings` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(40) NOT NULL default '',
  `server` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


ALTER TABLE `multicart_artists` ADD INDEX `seller_index` ( `vapproved` , `deleted` );

ALTER TABLE `multicart_artists` ADD INDEX `date_register` ( `date_registered` );

ALTER TABLE multicart_product_options  ADD INDEX `defaultoption` ( `product_id` , `default_option` );

ALTER TABLE `multicart_products` ADD INDEX `vapproved` (`vapproved`);

ALTER TABLE `multicart_products` ADD INDEX `date_added` (`date_added`);

ALTER TABLE `multicart_products` ADD INDEX `deleted` (`deleted`);

ALTER TABLE `multicart_product_impression` ADD INDEX `product_id` (`product_id`) ;

ALTER TABLE `multicart_orders` ADD INDEX `paymentstatus` ( `vpayment_status` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `order_id` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `payment_status`);

ALTER TABLE `multicart_shipping_details` ADD INDEX ( `norder_id`);

ALTER TABLE `multicart_artists` ADD COLUMN `storename` TEXT NULL AFTER `email`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_color` VARCHAR(50) NOT NULL AFTER `plan_expired`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_banner` VARCHAR(50) NOT NULL AFTER `theme_color`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_numrows` VARCHAR(255) NOT NULL AFTER `theme_banner`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_numcols` INT(10) NOT NULL AFTER `theme_numrows`;

ALTER TABLE `multicart_admin_menu` ADD COLUMN `title` TEXT NOT NULL DEFAULT '' AFTER `page_name`;

DROP TABLE IF EXISTS `multicart_language_master`;
CREATE TABLE `multicart_language_master` (
    `nlanguageId` INT(10) NOT NULL AUTO_INCREMENT,
    `languageName` VARCHAR(50) NOT NULL DEFAULT '0',
    `prevLanguage` VARCHAR(50) NULL DEFAULT '0',
    `langActive` ENUM('0','1') NULL DEFAULT '0',
    `langDeleteStatus` ENUM('0','1') NULL DEFAULT '0',
    PRIMARY KEY (`nlanguageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

ALTER TABLE `multicart_language_master` CHANGE COLUMN `prevLanguage` `prevLanguage` VARCHAR(50) NULL DEFAULT '0' AFTER `languageName`;
ALTER TABLE `multicart_language_master` ADD COLUMN `backupFile` VARCHAR(500) NULL DEFAULT '0' AFTER `prevLanguage`;

ALTER TABLE `multicart_helpcategory` CHANGE `htype` `htype` VARCHAR( 50 ) ;